/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vonage.client.conversations.AudioOutEvent;
import com.vonage.client.conversations.AudioSayEventBody;
import com.vonage.client.conversations.EventType;
import com.vonage.client.voice.TextToSpeechLanguage;
import java.util.UUID;

public final class AudioSayEvent
extends AudioOutEvent<AudioSayEventBody> {
    AudioSayEvent() {
    }

    private AudioSayEvent(Builder builder) {
        super(builder);
        this.body = new AudioSayEventBody(builder);
    }

    @JsonIgnore
    public UUID getSayId() {
        return this.body != null ? ((AudioSayEventBody)this.body).sayId : null;
    }

    @JsonIgnore
    public String getText() {
        return this.body != null ? ((AudioSayEventBody)this.body).text : null;
    }

    @JsonIgnore
    public Integer getStyle() {
        return this.body != null ? ((AudioSayEventBody)this.body).style : null;
    }

    @JsonIgnore
    public TextToSpeechLanguage getLanguage() {
        return this.body != null ? ((AudioSayEventBody)this.body).language : null;
    }

    @JsonIgnore
    public Boolean getPremium() {
        return this.body != null ? ((AudioSayEventBody)this.body).premium : null;
    }

    @JsonIgnore
    public Boolean getSsml() {
        return this.body != null ? ((AudioSayEventBody)this.body).ssml : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AudioOutEvent.Builder<AudioSayEvent, Builder> {
        String text;
        Integer style;
        TextToSpeechLanguage language;
        Boolean premium;
        Boolean ssml;

        Builder() {
            super(EventType.AUDIO_SAY);
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder style(int style) {
            this.style = style;
            return this;
        }

        public Builder language(TextToSpeechLanguage language) {
            this.language = language;
            return this;
        }

        public Builder premium(boolean premium) {
            this.premium = premium;
            return this;
        }

        public Builder ssml(boolean ssml) {
            this.ssml = ssml;
            return this;
        }

        @Override
        public AudioSayEvent build() {
            return new AudioSayEvent(this);
        }
    }
}

