/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum EventType {
    UNKNOWN,
    EPHEMERAL,
    CUSTOM,
    MESSAGE,
    MESSAGE_SUBMITTED,
    MESSAGE_REJECTED,
    MESSAGE_UNDELIVERABLE,
    MESSAGE_SEEN,
    MESSAGE_DELIVERED,
    AUDIO_PLAY,
    AUDIO_PLAY_STOP,
    AUDIO_SAY,
    AUDIO_SAY_STOP,
    AUDIO_DTMF,
    AUDIO_RECORD,
    AUDIO_RECORD_STOP,
    AUDIO_MUTE_ON,
    AUDIO_MUTE_OFF,
    AUDIO_EARMUFF_ON,
    AUDIO_EARMUFF_OFF,
    EVENT_DELETE,
    LEG_STATUS_UPDATE,
    CONVERSATION_UPDATED,
    AUDIO_SAY_DONE,
    AUDIO_PLAY_DONE,
    AUDIO_RECORD_DONE,
    AUDIO_SPEAKING_ON,
    AUDIO_SPEAKING_OFF,
    AUDIO_ASR_DONE,
    AUDIO_ASR_RECORD_DONE,
    MEMBER_MESSAGE_STATUS,
    MEMBER_INVITED,
    MEMBER_JOINED,
    MEMBER_LEFT,
    MEMBER_MEDIA,
    SIP_STATUS,
    SIP_HANGUP,
    SIP_ANSWERED,
    SIP_MACHINE,
    SIP_AMD_MACHINE,
    SIP_RINGING,
    RTC_STATUS,
    RTC_TRANSFER,
    RTC_HANGUP,
    RTC_ANSWERED,
    RTC_RINGING,
    RTC_ANSWER;


    @JsonCreator
    public static EventType fromString(String name) {
        if (name == null || name.trim().isEmpty()) {
            return null;
        }
        String upper = name.toUpperCase();
        if (upper.startsWith("CUSTOM:")) {
            return CUSTOM;
        }
        try {
            return EventType.valueOf(upper.replace(':', '_'));
        }
        catch (IllegalArgumentException ex) {
            return UNKNOWN;
        }
    }

    @JsonValue
    public String toString() {
        if (this == SIP_AMD_MACHINE) {
            return "sip:amd_machine";
        }
        return this.name().toLowerCase().replace('_', ':');
    }
}

