/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.vonage.client.common.ChannelType;
import com.vonage.client.conversations.BaseMember;
import com.vonage.client.conversations.MemberChannel;
import com.vonage.client.conversations.MemberInitiator;
import com.vonage.client.conversations.MemberMedia;
import com.vonage.client.conversations.MemberState;
import com.vonage.client.conversations.MemberTimestamp;
import com.vonage.client.users.BaseUser;
import com.vonage.client.users.channels.Channel;
import java.util.Objects;
import java.util.UUID;

public class Member
extends BaseMember {
    private String conversationId;
    private String memberIdInviting;
    private String from;
    private String invitedBy;
    private UUID knockingId;
    private MemberChannel channel;
    private MemberMedia media;
    private MemberInitiator initiator;
    private MemberTimestamp timestamp;

    protected Member() {
    }

    Member(Builder builder) {
        this.user = Objects.requireNonNull(builder.user, "User is required.");
        this.state = Objects.requireNonNull(builder.state, "State is required.");
        this.channel = Objects.requireNonNull(builder.channel, "Channel is required.");
        this.media = builder.media;
        this.knockingId = builder.knockingId;
        this.memberIdInviting = builder.memberIdInviting;
        this.from = builder.from;
    }

    @JsonSetter(value="conversation_id")
    void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    @JsonIgnore
    public String getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="channel")
    public MemberChannel getChannel() {
        return this.channel;
    }

    @JsonProperty(value="media")
    public MemberMedia getMedia() {
        return this.media;
    }

    @JsonProperty(value="knocking_id")
    public UUID getKnockingId() {
        return this.knockingId;
    }

    @JsonProperty(value="member_id_inviting")
    public String getMemberIdInviting() {
        return this.memberIdInviting;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="invited_by")
    public String getInvitedBy() {
        return this.invitedBy;
    }

    @JsonProperty(value="initiator")
    public MemberInitiator getInitiator() {
        return this.initiator;
    }

    @JsonProperty(value="timestamp")
    public MemberTimestamp getTimestamp() {
        return this.timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BaseUser user;
        private MemberState state;
        private MemberChannel channel;
        private MemberMedia media;
        private UUID knockingId;
        private String memberIdInviting;
        private String from;

        Builder() {
        }

        private MemberChannel initChannel() {
            if (this.channel == null) {
                this.channel = new MemberChannel();
            }
            return this.channel;
        }

        public Builder user(String userNameOrId) {
            if (userNameOrId == null || userNameOrId.trim().isEmpty()) {
                throw new IllegalArgumentException("Invalid user name or ID.");
            }
            this.user = userNameOrId.startsWith("USR-") && userNameOrId.length() == 40 ? new BaseUser(userNameOrId, null) : new BaseUser(null, userNameOrId);
            return this;
        }

        public Builder state(MemberState state) {
            this.state = state;
            return this;
        }

        public Builder channelType(ChannelType channelType) {
            this.initChannel().type = channelType;
            return this;
        }

        public Builder fromChannel(Channel from) {
            this.initChannel().from = from;
            this.initChannel().from.setTypeField();
            return this;
        }

        public Builder toChannel(Channel to) {
            this.initChannel().to = to;
            this.initChannel().to.setTypeField();
            return this;
        }

        public Builder media(MemberMedia media) {
            this.media = media;
            return this;
        }

        public Builder knockingId(String knockingId) {
            this.knockingId = UUID.fromString(knockingId);
            return this;
        }

        public Builder memberIdInviting(String memberIdInviting) {
            this.memberIdInviting = memberIdInviting;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Member build() {
            return new Member(this);
        }
    }
}

