/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.vonage.client.insight.RoamingDetails;
import com.vonage.client.insight.RoamingStatus;
import java.io.IOException;

class RoamingDeserializer
extends StdDeserializer<RoamingDetails> {
    RoamingDeserializer() {
        this(null);
    }

    RoamingDeserializer(Class<?> vc) {
        super(vc);
    }

    public RoamingDetails deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        RoamingStatus status = RoamingStatus.UNKNOWN;
        String roamingCountryCode = null;
        String roamingNetworkCode = null;
        String roamingNetworkName = null;
        if (node.getNodeType() == JsonNodeType.STRING) {
            status = RoamingStatus.fromString(node.asText());
        } else if (node.getNodeType() == JsonNodeType.OBJECT) {
            JsonNode rnn;
            JsonNode rnc;
            status = RoamingStatus.fromString(node.get("status").asText());
            JsonNode rcc = node.get("roaming_country_code");
            if (rcc != null) {
                roamingCountryCode = rcc.asText();
            }
            if ((rnc = node.get("roaming_network_code")) != null) {
                roamingNetworkCode = rnc.asText();
            }
            if ((rnn = node.get("roaming_network_name")) != null) {
                roamingNetworkName = rnn.asText();
            }
        }
        return new RoamingDetails(status, roamingCountryCode, roamingNetworkCode, roamingNetworkName);
    }
}

