/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.common.MessageType;
import com.vonage.client.common.UrlContainer;
import com.vonage.client.messages.Button;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessageStatus;
import com.vonage.client.messages.mms.Content;
import com.vonage.client.messages.sms.SmsInboundMetadata;
import com.vonage.client.messages.whatsapp.Context;
import com.vonage.client.messages.whatsapp.ContextStatus;
import com.vonage.client.messages.whatsapp.Location;
import com.vonage.client.messages.whatsapp.Order;
import com.vonage.client.messages.whatsapp.Profile;
import com.vonage.client.messages.whatsapp.Reaction;
import com.vonage.client.messages.whatsapp.Referral;
import com.vonage.client.messages.whatsapp.ReferredProduct;
import com.vonage.client.messages.whatsapp.Reply;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class InboundMessage
extends JsonableBaseObject {
    @JsonAnySetter
    protected Map<String, Object> unknownProperties;
    @JsonProperty(value="timestamp")
    protected Instant timestamp;
    @JsonProperty(value="channel")
    protected Channel channel;
    @JsonProperty(value="message_type")
    protected MessageType messageType;
    @JsonProperty(value="message_uuid")
    protected UUID messageUuid;
    @JsonProperty(value="to")
    protected String to;
    @JsonProperty(value="from")
    protected String from;
    @JsonProperty(value="client_ref")
    protected String clientRef;
    @JsonProperty(value="provider_message")
    String providerMessage;
    @JsonProperty(value="_self")
    UrlContainer self;
    @JsonProperty(value="text")
    protected String text;
    @JsonProperty(value="image")
    protected UrlWrapper image;
    @JsonProperty(value="audio")
    protected UrlWrapper audio;
    @JsonProperty(value="video")
    protected UrlWrapper video;
    @JsonProperty(value="file")
    protected UrlWrapper file;
    @JsonProperty(value="vcard")
    protected UrlWrapper vcard;
    @JsonProperty(value="sticker")
    protected UrlWrapper sticker;
    @JsonProperty(value="reaction")
    protected Reaction reaction;
    @JsonProperty(value="button")
    protected Button button;
    @JsonProperty(value="profile")
    protected Profile whatsappProfile;
    @JsonProperty(value="context_status")
    protected ContextStatus whatsappContextStatus;
    @JsonProperty(value="context")
    protected Context whatsappContext;
    @JsonProperty(value="location")
    protected Location whatsappLocation;
    @JsonProperty(value="reply")
    protected Reply whatsappReply;
    @JsonProperty(value="order")
    protected Order whatsappOrder;
    @JsonProperty(value="usage")
    protected MessageStatus.Usage usage;
    @JsonProperty(value="sms")
    protected SmsInboundMetadata smsMetadata;
    @JsonProperty(value="origin")
    protected Origin origin;
    @JsonProperty(value="whatsapp")
    private Whatsapp whatsapp;
    @JsonProperty(value="content")
    protected List<Content> content;

    protected InboundMessage() {
    }

    @JsonAnyGetter
    public Map<String, ?> getUnmappedProperties() {
        return this.unknownProperties;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public UUID getMessageUuid() {
        return this.messageUuid;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getClientRef() {
        return this.clientRef;
    }

    @JsonIgnore
    public URI getSelfUrl() {
        return this.self != null ? this.self.getHref() : null;
    }

    public String getText() {
        return this.text;
    }

    @JsonIgnore
    public URI getImageUrl() {
        return this.image != null ? this.image.url : null;
    }

    @JsonIgnore
    public String getImageCaption() {
        return this.image != null ? this.image.caption : null;
    }

    @JsonIgnore
    public URI getAudioUrl() {
        return this.audio != null ? this.audio.url : null;
    }

    @JsonIgnore
    public URI getVideoUrl() {
        return this.video != null ? this.video.url : null;
    }

    @JsonIgnore
    public URI getFileUrl() {
        return this.file != null ? this.file.url : null;
    }

    @JsonIgnore
    public String getFileName() {
        return this.file != null ? this.file.name : null;
    }

    @JsonIgnore
    public String getFileCaption() {
        return this.file != null ? this.file.caption : null;
    }

    @JsonIgnore
    public URI getVcardUrl() {
        return this.vcard != null ? this.vcard.url : null;
    }

    @JsonIgnore
    public String getVcardName() {
        return this.vcard != null ? this.vcard.name : null;
    }

    @JsonIgnore
    public URI getStickerUrl() {
        return this.sticker != null ? this.sticker.url : null;
    }

    public Reaction getReaction() {
        return this.reaction;
    }

    public Button getButton() {
        return this.button;
    }

    public String getProviderMessage() {
        return this.providerMessage;
    }

    public Location getWhatsappLocation() {
        return this.whatsappLocation;
    }

    public Reply getWhatsappReply() {
        return this.whatsappReply;
    }

    public Order getWhatsappOrder() {
        return this.whatsappOrder;
    }

    public Profile getWhatsappProfile() {
        return this.whatsappProfile;
    }

    public Context getWhatsappContext() {
        return this.whatsappContext;
    }

    public ContextStatus getWhatsappContextStatus() {
        return this.whatsappContextStatus;
    }

    public MessageStatus.Usage getUsage() {
        return this.usage;
    }

    public SmsInboundMetadata getSmsMetadata() {
        return this.smsMetadata;
    }

    @JsonIgnore
    public String getNetworkCode() {
        return this.origin != null ? this.origin.networkCode : null;
    }

    @JsonIgnore
    public Referral getWhatsappReferral() {
        return this.whatsapp != null ? this.whatsapp.referral : null;
    }

    @JsonIgnore
    public ReferredProduct getWhatsappReferredProduct() {
        return this.whatsapp != null ? this.whatsapp.referredProduct : null;
    }

    @JsonProperty(value="content")
    public List<Content> getContent() {
        return this.content;
    }

    @JsonCreator
    public static InboundMessage fromJson(String json) {
        return (InboundMessage)Jsonable.fromJson((String)json, (Jsonable[])new InboundMessage[0]);
    }

    protected static class UrlWrapper
    extends JsonableBaseObject {
        @JsonProperty(value="url")
        protected URI url;
        @JsonProperty(value="name")
        protected String name;
        @JsonProperty(value="caption")
        protected String caption;

        protected UrlWrapper() {
        }
    }

    protected static class Origin
    extends JsonableBaseObject {
        @JsonProperty(value="network_code")
        protected String networkCode;

        protected Origin() {
        }
    }

    protected static class Whatsapp
    extends JsonableBaseObject {
        @JsonProperty(value="referral")
        protected Referral referral;
        @JsonProperty(value="whatsapp_referred_product")
        protected ReferredProduct referredProduct;

        protected Whatsapp() {
        }
    }
}

