/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.common.E164;
import com.vonage.client.common.MessageType;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessagesVersion;
import com.vonage.client.messages.internal.MessagePayload;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class MessageRequest
extends JsonableBaseObject {
    final MessageType messageType;
    final Channel channel;
    protected String from;
    protected String to;
    final String clientRef;
    final URI webhookUrl;
    final MessagesVersion webhookVersion;
    final List<MessageRequest> failover;
    protected final Integer ttl;
    final String text;
    protected final Map<String, Object> custom;
    @JsonIgnore
    protected final MessagePayload media;

    protected MessageRequest(Builder<?, ?> builder, Channel channel, MessageType messageType) {
        this.messageType = Objects.requireNonNull(messageType, "Message type cannot be null");
        this.channel = Objects.requireNonNull(channel, "Channel cannot be null");
        if (!this.channel.getSupportedOutboundMessageTypes().contains((Object)this.messageType)) {
            throw new IllegalArgumentException((Object)((Object)this.messageType) + " cannot be sent via " + (Object)((Object)this.channel));
        }
        this.ttl = ((Builder)builder).ttl;
        if (this.ttl != null && this.ttl < 1) {
            throw new IllegalArgumentException("TTL must be positive.");
        }
        this.from = ((Builder)builder).from;
        this.to = ((Builder)builder).to;
        this.validateSenderAndRecipient(this.from, this.to);
        this.clientRef = this.validateClientReference(((Builder)builder).clientRef);
        this.webhookUrl = ((Builder)builder).webhookUrl;
        this.webhookVersion = ((Builder)builder).webhookVersion;
        this.failover = ((Builder)builder).failover;
        MessagePayload media = null;
        Map custom = null;
        String text = null;
        switch (messageType) {
            case TEXT: {
                text = Objects.requireNonNull(((Builder)builder).text, "Text message cannot be null.");
                if (text.isEmpty()) {
                    throw new IllegalArgumentException("Text message cannot be blank.");
                }
                if (text.length() <= this.maxTextLength()) break;
                throw new IllegalArgumentException("Text message cannot be longer than " + this.maxTextLength() + " characters.");
            }
            case CUSTOM: {
                custom = ((Builder)builder).custom != null ? ((Builder)builder).custom : new LinkedHashMap(8);
                break;
            }
            case IMAGE: 
            case AUDIO: 
            case VIDEO: 
            case FILE: 
            case VCARD: {
                media = new MessagePayload(((Builder)builder).url, ((Builder)builder).caption, ((Builder)builder).name);
                break;
            }
        }
        this.text = text;
        this.media = media;
        this.custom = custom;
    }

    protected String validateClientReference(String clientRef) {
        int limit = 100;
        if (clientRef != null && clientRef.length() > limit) {
            throw new IllegalArgumentException("Client reference cannot be longer than " + limit + " characters.");
        }
        return clientRef;
    }

    protected void validateSenderAndRecipient(String from, String to) throws IllegalArgumentException {
        if (from == null || from.isEmpty()) {
            throw new IllegalArgumentException("Sender cannot be empty.");
        }
        this.to = new E164(to).toString();
    }

    @JsonIgnore
    protected int maxTextLength() {
        return 1000;
    }

    @JsonProperty(value="message_type")
    public MessageType getMessageType() {
        return this.messageType;
    }

    @JsonProperty(value="channel")
    public Channel getChannel() {
        return this.channel;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonProperty(value="client_ref")
    public String getClientRef() {
        return this.clientRef;
    }

    @JsonProperty(value="webhook_url")
    public URI getWebhookUrl() {
        return this.webhookUrl;
    }

    @JsonProperty(value="webhook_version")
    public MessagesVersion getWebhookVersion() {
        return this.webhookVersion;
    }

    @JsonProperty(value="failover")
    public List<MessageRequest> getFailover() {
        return this.failover;
    }

    @JsonProperty(value="ttl")
    protected Integer getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="text")
    protected String getText() {
        return this.text;
    }

    @JsonProperty(value="custom")
    protected Map<String, ?> getCustom() {
        return this.custom;
    }

    public static abstract class Builder<M extends MessageRequest, B extends Builder<? extends M, ? extends B>> {
        private String from;
        private String to;
        private String clientRef;
        private String text;
        private String url;
        private String caption;
        private String name;
        private URI webhookUrl;
        private MessagesVersion webhookVersion;
        private List<MessageRequest> failover;
        private Integer ttl;
        private Map<String, Object> custom;

        protected Builder() {
        }

        public B from(String from) {
            this.from = from;
            return (B)this;
        }

        protected B custom(Map<String, ?> payload) {
            this.custom = new LinkedHashMap(payload);
            return (B)this;
        }

        public B to(String to) {
            this.to = to;
            return (B)this;
        }

        public B clientRef(String clientRef) {
            this.clientRef = clientRef;
            return (B)this;
        }

        public B webhookUrl(String webhookUrl) {
            return this.webhookUrl(URI.create(webhookUrl));
        }

        private B webhookUrl(URI webhookUrl) {
            this.webhookUrl = webhookUrl;
            return (B)this;
        }

        public B webhookVersion(MessagesVersion webhookVersion) {
            this.webhookVersion = webhookVersion;
            return (B)this;
        }

        protected B ttl(int ttl) {
            this.ttl = ttl;
            return (B)this;
        }

        protected B text(String text) {
            this.text = text;
            return (B)this;
        }

        protected B url(String url) {
            this.url = url;
            return (B)this;
        }

        protected B caption(String caption) {
            this.caption = caption;
            return (B)this;
        }

        protected B name(String name) {
            this.name = name;
            return (B)this;
        }

        public B failover(MessageRequest ... failover) {
            return this.failover(Arrays.asList(failover));
        }

        public B failover(List<MessageRequest> failover) {
            this.failover = failover;
            return (B)this;
        }

        public abstract M build();
    }
}

