/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.mms;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.common.MessageType;
import com.vonage.client.messages.CaptionMediaMessageRequest;
import com.vonage.client.messages.mms.Content;
import com.vonage.client.messages.mms.MmsRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class MmsContentRequest
extends MmsRequest
implements CaptionMediaMessageRequest {
    private final List<Content> content;

    MmsContentRequest(Builder builder) {
        super(builder, MessageType.CONTENT);
        this.content = builder.content;
        if (this.content.isEmpty()) {
            throw new IllegalArgumentException("At least one content item is required.");
        }
    }

    @JsonProperty(value="content")
    public List<Content> getContent() {
        return this.content;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends MmsRequest.Builder<MmsContentRequest, Builder> {
        private List<Content> content = new ArrayList<Content>();

        Builder() {
        }

        public Builder addVcard(String url, String caption) {
            this.content.add(new Content(MessageType.VCARD, url, caption));
            return this;
        }

        public Builder addVcard(String url) {
            return this.addVcard(url, null);
        }

        public Builder addAudio(String url, String caption) {
            this.content.add(new Content(MessageType.AUDIO, url, caption));
            return this;
        }

        public Builder addAudio(String url) {
            return this.addAudio(url, null);
        }

        public Builder addVideo(String url, String caption) {
            this.content.add(new Content(MessageType.VIDEO, url, caption));
            return this;
        }

        public Builder addVideo(String url) {
            return this.addVideo(url, null);
        }

        public Builder addImage(String url, String caption) {
            this.content.add(new Content(MessageType.IMAGE, url, caption));
            return this;
        }

        public Builder addImage(String url) {
            return this.addImage(url, null);
        }

        public Builder addFile(String url, String caption) {
            this.content.add(new Content(MessageType.FILE, url, caption));
            return this;
        }

        public Builder addFile(String url) {
            return this.addFile(url, null);
        }

        public Builder addContent(Content ... contents) {
            this.content.addAll(Arrays.asList(contents));
            return this;
        }

        public Builder contents(List<Content> content) {
            this.content = Objects.requireNonNull(content, "Content list cannot be null.");
            return this;
        }

        @Override
        public MmsContentRequest build() {
            return new MmsContentRequest(this);
        }
    }
}

