/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.mms;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.common.MessageType;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessageRequest;

public abstract class MmsRequest
extends MessageRequest {
    protected MmsRequest(Builder<?, ?> builder, MessageType messageType) {
        super(builder, Channel.MMS, messageType);
        if (this.media != null) {
            this.media.validateCaptionLength(2000);
        }
        int min = 300;
        int max = 259200;
        if (this.ttl != null && (this.ttl < min || this.ttl > max)) {
            throw new IllegalArgumentException("TTL must be between " + min + " and " + max + " seconds.");
        }
    }

    @Override
    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    protected static abstract class Builder<M extends MmsRequest, B extends Builder<? extends M, ? extends B>>
    extends MessageRequest.Builder<M, B> {
        protected Builder() {
        }

        @Override
        public B ttl(int ttl) {
            return (B)((Builder)super.ttl(ttl));
        }
    }
}

