/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.messages.internal.MessagePayload;
import java.net.URI;
import java.util.UUID;

public final class Sticker
extends JsonableBaseObject {
    private final URI url;
    private final UUID id;

    Sticker(String url, String id) {
        boolean noUrl;
        boolean noId = id == null;
        boolean bl = noUrl = url == null;
        if (noId && noUrl || !noId && !noUrl) {
            throw new IllegalStateException("Must specify either an ID or URL for sticker, but not both.");
        }
        if (noId) {
            MessagePayload.validateExtension(url, ".webp");
            this.url = URI.create(url);
            this.id = null;
        } else {
            this.id = UUID.fromString(id);
            this.url = null;
        }
    }

    @JsonProperty(value="url")
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }
}

