/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.common.MessageType;
import com.vonage.client.messages.whatsapp.Reaction;
import com.vonage.client.messages.whatsapp.WhatsappRequest;
import java.util.Objects;

public final class WhatsappReactionRequest
extends WhatsappRequest {
    final Reaction reaction;

    WhatsappReactionRequest(Builder builder) {
        super(builder, MessageType.REACTION);
        this.reaction = Objects.requireNonNull(builder.reaction, "Reaction is required.");
        if (this.getContext() == null) {
            throw new IllegalStateException("Context message ID is required.");
        }
    }

    @JsonProperty(value="reaction")
    public Reaction getReaction() {
        return this.reaction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WhatsappRequest.Builder<WhatsappReactionRequest, Builder> {
        private Reaction reaction;

        Builder() {
        }

        public Builder reaction(String emoji) {
            this.reaction = new Reaction(emoji);
            return this;
        }

        public Builder unreact() {
            this.reaction = new Reaction();
            return this;
        }

        @Override
        public WhatsappReactionRequest build() {
            return new WhatsappReactionRequest(this);
        }
    }
}

