/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.common.MessageType;
import com.vonage.client.messages.whatsapp.Locale;
import com.vonage.client.messages.whatsapp.Policy;
import com.vonage.client.messages.whatsapp.Template;
import com.vonage.client.messages.whatsapp.Whatsapp;
import com.vonage.client.messages.whatsapp.WhatsappRequest;
import java.util.List;

public final class WhatsappTemplateRequest
extends WhatsappRequest {
    final Template template;
    final Whatsapp whatsapp;

    WhatsappTemplateRequest(Builder builder) {
        super(builder, MessageType.TEMPLATE);
        this.template = new Template(builder.name, builder.parameters);
        this.whatsapp = new Whatsapp(builder.policy, builder.locale);
    }

    @JsonProperty(value="template")
    public Template getTemplate() {
        return this.template;
    }

    @JsonProperty(value="whatsapp")
    public Whatsapp getWhatsapp() {
        return this.whatsapp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WhatsappRequest.Builder<WhatsappTemplateRequest, Builder> {
        String name;
        List<String> parameters;
        Locale locale = Locale.ENGLISH;
        Policy policy;

        Builder() {
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder parameters(List<String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder policy(Policy policy) {
            this.policy = policy;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public WhatsappTemplateRequest build() {
            return new WhatsappTemplateRequest(this);
        }
    }
}

