/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.numbers.BaseNumbersFilter;
import java.util.Map;
import java.util.UUID;

public class ListNumbersFilter
extends BaseNumbersFilter {
    private final UUID applicationId;
    private final Boolean hasApplication;

    private ListNumbersFilter(Builder builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.hasApplication = builder.hasApplication;
    }

    public UUID getApplicationId() {
        return this.applicationId;
    }

    public Boolean getHasApplication() {
        return this.hasApplication;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        this.conditionalAdd("application_id", this.applicationId);
        this.conditionalAdd("has_application", this.hasApplication);
        return params;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BaseNumbersFilter.Builder<ListNumbersFilter, Builder> {
        private UUID applicationId;
        private Boolean hasApplication;

        Builder() {
        }

        public Builder applicationId(String applicationId) {
            return this.applicationId(UUID.fromString(applicationId));
        }

        public Builder applicationId(UUID applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder hasApplication(boolean hasApplication) {
            this.hasApplication = hasApplication;
            return this;
        }

        @Override
        public ListNumbersFilter build() {
            return new ListNumbersFilter(this);
        }
    }
}

