/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.auth.ApiKeyHeaderAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.numbers.BuyCancelNumberRequest;
import com.vonage.client.numbers.CallbackType;
import com.vonage.client.numbers.ListNumbersFilter;
import com.vonage.client.numbers.ListNumbersResponse;
import com.vonage.client.numbers.NumbersResponseException;
import com.vonage.client.numbers.OwnedNumber;
import com.vonage.client.numbers.SearchNumbersFilter;
import com.vonage.client.numbers.SearchNumbersResponse;
import com.vonage.client.numbers.UpdateNumberRequest;
import java.util.List;
import java.util.UUID;

public class NumbersClient {
    final RestEndpoint<ListNumbersFilter, ListNumbersResponse> listNumbers;
    final RestEndpoint<SearchNumbersFilter, SearchNumbersResponse> searchNumbers;
    final RestEndpoint<BuyCancelNumberRequest, Void> buyNumber;
    final RestEndpoint<BuyCancelNumberRequest, Void> cancelNumber;
    final RestEndpoint<UpdateNumberRequest, Void> updateNumber;

    public NumbersClient(final HttpWrapper wrapper) {
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(String path, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).responseExceptionType(NumbersResponseException.class).wrapper(var5_5).requestMethod(method).authMethod(ApiKeyHeaderAuthMethod.class, new Class[0]).urlFormEncodedContentType(method == HttpMethod.POST).pathGetter((de, req) -> de.getHttpWrapper().getHttpConfig().getRestBaseUri() + "/" + path));
            }
        }
        this.listNumbers = new Endpoint("account/numbers", HttpMethod.GET, (Object[])new ListNumbersResponse[0]);
        this.searchNumbers = new Endpoint("number/search", HttpMethod.GET, (Object[])new SearchNumbersResponse[0]);
        this.cancelNumber = new Endpoint("number/cancel", HttpMethod.POST, (Object[])new Void[0]);
        this.buyNumber = new Endpoint("number/buy", HttpMethod.POST, (Object[])new Void[0]);
        this.updateNumber = new Endpoint("number/update", HttpMethod.POST, (Object[])new Void[0]);
    }

    public List<OwnedNumber> listNumbers() throws NumbersResponseException {
        return this.listNumbers(ListNumbersFilter.builder().build());
    }

    public List<OwnedNumber> listNumbers(ListNumbersFilter filter) throws NumbersResponseException {
        return this.listNumbers.execute(filter).getNumbers();
    }

    public SearchNumbersResponse searchNumbers(String country) throws NumbersResponseException {
        return this.searchNumbers(((SearchNumbersFilter.Builder)SearchNumbersFilter.builder().country(country)).build());
    }

    public SearchNumbersResponse searchNumbers(SearchNumbersFilter filter) throws NumbersResponseException {
        return this.searchNumbers.execute(filter);
    }

    public void buyNumber(String country, String msisdn) throws NumbersResponseException {
        this.buyNumber(country, msisdn, null);
    }

    public void buyNumber(String country, String msisdn, String targetApiKey) throws NumbersResponseException {
        this.buyNumber.execute(new BuyCancelNumberRequest(country, msisdn, targetApiKey));
    }

    public void cancelNumber(String country, String msisdn) throws NumbersResponseException {
        this.cancelNumber(country, msisdn, null);
    }

    public void cancelNumber(String country, String msisdn, String targetApiKey) throws NumbersResponseException {
        this.cancelNumber.execute(new BuyCancelNumberRequest(country, msisdn, targetApiKey));
    }

    public void updateNumber(UpdateNumberRequest request) throws NumbersResponseException {
        this.updateNumber.execute(request);
    }

    public void linkNumber(String msisdn, String country, String appId) throws NumbersResponseException {
        this.updateNumber(UpdateNumberRequest.builder(msisdn, country).applicationId(appId).voiceCallback(CallbackType.APP, UUID.fromString(appId).toString()).build());
    }
}

