/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.numbers.BaseNumberRequest;
import com.vonage.client.numbers.CallbackType;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class UpdateNumberRequest
extends BaseNumberRequest {
    private final UUID applicationId;
    private final CallbackType voiceCallbackType;
    private final URI moHttpUrl;
    private final URI voiceStatusCallback;
    private final String moSmppSysType;
    private final String voiceCallbackValue;

    private UpdateNumberRequest(Builder builder) {
        super(builder.country, builder.msisdn);
        this.applicationId = builder.appId;
        this.moHttpUrl = builder.moHttpUrl;
        this.voiceStatusCallback = builder.voiceStatusCallback;
        this.moSmppSysType = builder.moSmppSysType;
        this.voiceCallbackType = builder.voiceCallbackType;
        this.voiceCallbackValue = builder.voiceCallbackValue;
    }

    public UUID getApplicationId() {
        return this.applicationId;
    }

    public String getMoHttpUrl() {
        return this.moHttpUrl != null ? this.moHttpUrl.toString() : null;
    }

    public String getMoSmppSysType() {
        return this.moSmppSysType;
    }

    public CallbackType getVoiceCallbackType() {
        return this.voiceCallbackType;
    }

    public String getVoiceCallbackValue() {
        return this.voiceCallbackValue;
    }

    public String getVoiceStatusCallback() {
        return this.voiceStatusCallback != null ? this.voiceStatusCallback.toString() : null;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        this.conditionalAdd("app_id", this.applicationId);
        this.conditionalAdd("moHttpUrl", this.moHttpUrl);
        this.conditionalAdd("moSmppSysType", this.moSmppSysType);
        this.conditionalAdd("voiceCallbackType", (Object)this.voiceCallbackType);
        this.conditionalAdd("voiceCallbackValue", this.voiceCallbackValue);
        this.conditionalAdd("voiceStatusCallback", this.voiceStatusCallback);
        return params;
    }

    public static Builder builder(String msisdn, String country) {
        return new Builder(msisdn, country);
    }

    public static class Builder {
        private final String country;
        private final String msisdn;
        private String moSmppSysType;
        private String voiceCallbackValue;
        private CallbackType voiceCallbackType;
        private UUID appId;
        private URI moHttpUrl;
        private URI voiceStatusCallback;

        private Builder(String msisdn, String country) {
            this.country = country;
            this.msisdn = msisdn;
        }

        public Builder moSmppSysType(String moSmppSysType) {
            this.moSmppSysType = moSmppSysType;
            return this;
        }

        public Builder voiceCallback(CallbackType type, String voiceCallbackValue) {
            this.voiceCallbackType = Objects.requireNonNull(type, "Voice callback type is required.)");
            this.voiceCallbackValue = Objects.requireNonNull(voiceCallbackValue, "Voice callback value is required.");
            return this;
        }

        public Builder applicationId(String appId) {
            return this.applicationId(UUID.fromString(appId));
        }

        public Builder applicationId(UUID appId) {
            this.appId = appId;
            return this;
        }

        public Builder moHttpUrl(String moHttpUrl) {
            return this.moHttpUrl(URI.create(moHttpUrl));
        }

        public Builder moHttpUrl(URI moHttpUrl) {
            this.moHttpUrl = moHttpUrl;
            return this;
        }

        public Builder voiceStatusCallback(String voiceStatusCallback) {
            return this.voiceStatusCallback(URI.create(voiceStatusCallback));
        }

        public Builder voiceStatusCallback(URI voiceStatusCallback) {
            this.voiceStatusCallback = voiceStatusCallback;
            return this;
        }

        public UpdateNumberRequest build() {
            return new UpdateNumberRequest(this);
        }
    }
}

