/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.redact;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.auth.ApiKeyHeaderAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.redact.Product;
import com.vonage.client.redact.RedactRequest;
import com.vonage.client.redact.RedactResponseException;
import com.vonage.client.redact.Type;

public class RedactClient {
    final RestEndpoint<RedactRequest, Void> redactTransaction;

    public RedactClient(final HttpWrapper wrapper) {
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(R ... type) {
                super(DynamicEndpoint.builder(type).wrapper(var3_3).requestMethod(HttpMethod.POST).responseExceptionType(RedactResponseException.class).authMethod(ApiKeyHeaderAuthMethod.class, new Class[0]).pathGetter((de, req) -> de.getHttpWrapper().getHttpConfig().getApiBaseUri() + "/v1/redact/transaction"));
            }
        }
        this.redactTransaction = new Endpoint((Object[])new Void[0]);
    }

    public void redactTransaction(String id, Product product) throws VonageResponseParseException, VonageClientException {
        this.redactTransaction(new RedactRequest(id, product));
    }

    public void redactTransaction(String id, Product product, Type type) throws VonageResponseParseException, VonageClientException {
        RedactRequest request = new RedactRequest(id, product);
        request.setType(type);
        this.redactTransaction(request);
    }

    void redactTransaction(RedactRequest redactRequest) throws VonageResponseParseException, VonageClientException {
        if (redactRequest.getId() == null || redactRequest.getProduct() == null) {
            throw new IllegalArgumentException("Redact transaction id and product are required.");
        }
        if (redactRequest.getProduct() == Product.SMS && redactRequest.getType() == null) {
            throw new IllegalArgumentException("Redacting SMS requires a type.");
        }
        this.redactTransaction.execute(redactRequest);
    }
}

