/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.sms.messages;

import com.vonage.client.sms.messages.Message;
import com.vonage.client.sms.messages.MessageType;
import java.util.Formatter;
import java.util.Map;

public class BinaryMessage
extends Message {
    private final byte[] messageBody;
    private final byte[] udh;
    private int protocolId = 0;

    public BinaryMessage(String from, String to, byte[] messageBody, byte[] udh) {
        super(MessageType.BINARY, from, to);
        this.messageBody = messageBody;
        this.udh = udh;
    }

    public byte[] getMessageBody() {
        return (byte[])this.messageBody.clone();
    }

    public byte[] getUdh() {
        return (byte[])this.udh.clone();
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(int protocolId) {
        this.protocolId = protocolId;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        this.conditionalAdd("udh", BinaryMessage.toHexString(this.getUdh()));
        this.conditionalAdd("body", BinaryMessage.toHexString(this.getMessageBody()));
        this.conditionalAdd("protocol-id", this.getProtocolId());
        return params;
    }

    private static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        Formatter formatter = new Formatter(sb);
        for (byte b : data) {
            formatter.format("%02x", b);
        }
        return sb.toString();
    }
}

