/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.subaccounts;

import com.vonage.client.AbstractQueryParamsRequest;
import com.vonage.client.subaccounts.AbstractTransfer;
import java.time.Instant;
import java.util.Map;

public class ListTransfersFilter
extends AbstractQueryParamsRequest {
    private final Instant startDate;
    private final Instant endDate;
    private final String subaccount;

    ListTransfersFilter(Builder builder) {
        this.startDate = builder.startDate != null ? builder.startDate : Instant.EPOCH;
        this.endDate = builder.endDate;
        this.subaccount = builder.subaccount;
        if (this.subaccount != null) {
            AbstractTransfer.validateAccountKey(builder.subaccount, "Subaccount");
        }
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        this.conditionalAdd("start_date", this.startDate);
        this.conditionalAdd("end_date", this.endDate);
        this.conditionalAdd("subaccount", this.subaccount);
        return params;
    }

    public Instant getStartDate() {
        return this.startDate;
    }

    public Instant getEndDate() {
        return this.endDate;
    }

    public String getSubaccount() {
        return this.subaccount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Instant startDate;
        private Instant endDate;
        private String subaccount;

        Builder() {
        }

        public Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder subaccount(String subaccount) {
            this.subaccount = subaccount;
            return this;
        }

        public ListTransfersFilter build() {
            return new ListTransfersFilter(this);
        }
    }
}

