/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.users;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.users.BaseUser;
import com.vonage.client.users.channels.Channel;
import com.vonage.client.users.channels.Channels;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class User
extends BaseUser {
    @JsonProperty(value="display_name")
    private String displayName;
    @JsonProperty(value="image_url")
    private URI imageUrl;
    @JsonProperty(value="channels")
    private Channels channels;
    @JsonProperty(value="properties")
    private Properties properties;
    @JsonProperty(value="custom_data")
    private Map<String, ?> customData;

    protected User() {
    }

    protected User(Builder builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.imageUrl = builder.imageUrl;
        this.channels = builder.channels;
        if (builder.customData != null) {
            this.properties = new Properties();
            this.properties.customData = builder.customData;
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public URI getImageUrl() {
        return this.imageUrl;
    }

    @JsonIgnore
    public Map<String, ?> getCustomData() {
        return this.properties != null ? this.properties.customData : this.customData;
    }

    public Channels getChannels() {
        return this.channels;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String displayName;
        private URI imageUrl;
        private Map<String, ?> customData;
        private Channels channels;

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            this.imageUrl = URI.create(imageUrl);
            return this;
        }

        public Builder customData(Map<String, ?> customData) {
            this.customData = customData;
            return this;
        }

        public Builder channels(Channel ... channels) {
            return this.channels(Arrays.asList(channels));
        }

        public Builder channels(Collection<? extends Channel> channels) {
            this.channels = new Channels(channels);
            return this;
        }

        public User build() {
            return new User(this);
        }
    }

    static class Properties
    extends JsonableBaseObject {
        @JsonProperty(value="custom_data")
        Map<String, ?> customData;

        Properties() {
        }
    }
}

