/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.users.channels;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.common.ChannelType;
import com.vonage.client.users.channels.Messenger;
import com.vonage.client.users.channels.Mms;
import com.vonage.client.users.channels.Pstn;
import com.vonage.client.users.channels.Sip;
import com.vonage.client.users.channels.Sms;
import com.vonage.client.users.channels.Vbc;
import com.vonage.client.users.channels.Viber;
import com.vonage.client.users.channels.Websocket;
import com.vonage.client.users.channels.Whatsapp;
import com.vonage.client.users.channels.WhatsappVoice;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Messenger.class, name="messenger"), @JsonSubTypes.Type(value=Mms.class, name="mms"), @JsonSubTypes.Type(value=Pstn.class, names={"phone", "pstn"}), @JsonSubTypes.Type(value=Sip.class, name="sip"), @JsonSubTypes.Type(value=Sms.class, name="sms"), @JsonSubTypes.Type(value=Vbc.class, name="vbc"), @JsonSubTypes.Type(value=Viber.class, name="viber"), @JsonSubTypes.Type(value=Websocket.class, name="websocket"), @JsonSubTypes.Type(value=Whatsapp.class, name="whatsapp"), @JsonSubTypes.Type(value=WhatsappVoice.class, name="whatsapp-voice")})
public abstract class Channel
extends JsonableBaseObject {
    protected ChannelType type;

    @JsonProperty(value="type")
    public ChannelType getType() {
        return this.type;
    }

    @JsonIgnore
    public void setTypeField() {
        String name = this.getClass().getSimpleName();
        if (name.equals("Pstn")) {
            name = "Phone";
        }
        if (name.equals("WhatsappVoice")) {
            name = "whatsapp-voice";
        }
        this.type = ChannelType.fromString(name);
    }

    public void removeTypeField() {
        this.type = null;
    }

    public static Class<? extends Channel> getConcreteClass(ChannelType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            default: {
                return null;
            }
            case MESSENGER: {
                return Messenger.class;
            }
            case MMS: {
                return Mms.class;
            }
            case PHONE: {
                return Pstn.class;
            }
            case SIP: {
                return Sip.class;
            }
            case SMS: {
                return Sms.class;
            }
            case VBC: {
                return Vbc.class;
            }
            case VIBER: {
                return Viber.class;
            }
            case WEBSOCKET: {
                return Websocket.class;
            }
            case WHATSAPP: {
                return Whatsapp.class;
            }
            case WHATSAPP_VOICE: 
        }
        return WhatsappVoice.class;
    }
}

