/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.users.channels;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.users.channels.Channel;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE, visible=true)
public class Websocket
extends Channel {
    private URI uri;
    private ContentType contentType;
    private Map<String, ?> headers;

    protected Websocket() {
    }

    public Websocket(String uri) {
        Objects.requireNonNull(uri, "Websocket URI is required");
        if (!uri.startsWith("ws://") && !uri.startsWith("wss://")) {
            throw new IllegalArgumentException("Invalid websocket URI protocol.");
        }
        this.uri = URI.create(uri);
    }

    public Websocket(String uri, ContentType contentType, Map<String, ?> headers) {
        this(uri);
        this.contentType = contentType;
        this.headers = headers;
    }

    @JsonProperty(value="uri")
    public URI getUri() {
        return this.uri;
    }

    @JsonProperty(value="content-type")
    public ContentType getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="headers")
    public Map<String, ?> getHeaders() {
        return this.headers;
    }

    public static enum ContentType {
        AUDIO_L16_8K("audio/l16;rate=8000"),
        AUDIO_L16_16K("audio/l16;rate=16000");

        private final String value;

        private ContentType(String ser) {
            this.value = ser;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ContentType fromString(String value) {
            if (value == null) {
                return null;
            }
            switch (value.toLowerCase()) {
                case "audio/l16;rate=8000": {
                    return AUDIO_L16_8K;
                }
                case "audio/l16;rate=16000": {
                    return AUDIO_L16_16K;
                }
            }
            throw new IllegalArgumentException("Unknown content-type: " + value);
        }
    }
}

