/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.vonage.client.AbstractQueryParamsRequest;
import java.util.Map;

class CheckRequest
extends AbstractQueryParamsRequest {
    private final String requestId;
    private final String code;

    CheckRequest(String requestId, String code) {
        this.requestId = requestId;
        if (this.requestId == null) {
            throw new IllegalArgumentException("request_id is required");
        }
        this.code = code;
        if (this.code == null) {
            throw new IllegalArgumentException("code is required");
        }
        if (requestId.length() > 32) {
            throw new IllegalArgumentException("request_id '" + requestId + "' is longer than 32 characters");
        }
        if (code.length() < 4 || code.length() > 6) {
            throw new IllegalArgumentException("code '" + code + "' is not between 4 and 6 characters long");
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        this.conditionalAdd("request_id", this.requestId);
        this.conditionalAdd("code", this.code);
        return params;
    }
}

