/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.vonage.client.verify.BaseRequest;
import com.vonage.client.verify.Workflow;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class VerifyRequest
extends BaseRequest {
    private final String brand;
    private final String from;
    private final String pinCode;
    private final Workflow workflow;

    public VerifyRequest(Builder builder) {
        super(builder.number, builder.length, builder.locale, builder.country, builder.pinExpiry, builder.nextEventWait);
        this.brand = Objects.requireNonNull(builder.brand, "Brand is required.");
        if (this.brand.length() > 18) {
            throw new IllegalArgumentException("Brand '" + this.brand + "' is longer than 18 characters.");
        }
        this.pinCode = builder.pinCode;
        if (this.pinCode != null && (this.pinCode.length() < 4 || this.pinCode.length() > 10)) {
            throw new IllegalArgumentException("Pin code must be between 4 and 10 characters.");
        }
        this.from = builder.senderId;
        this.workflow = builder.workflow;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getFrom() {
        return this.from;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public String getPinCode() {
        return this.pinCode;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        this.conditionalAdd("brand", this.brand);
        this.conditionalAdd("sender_id", this.from);
        this.conditionalAdd("pin_code", this.pinCode);
        if (this.workflow != null) {
            this.conditionalAdd("workflow_id", this.workflow.getId());
        }
        return params;
    }

    @Override
    public String toString() {
        return "VerifyRequest{" + super.toString() + ", brand='" + this.brand + '\'' + ", workflow=" + (Object)((Object)this.workflow) + '}';
    }

    public static Builder builder(String number, String brand) {
        return new Builder(number, brand);
    }

    public static class Builder {
        private final String brand;
        private final String number;
        private String senderId;
        private String country;
        private String pinCode;
        private Integer length;
        private Integer pinExpiry;
        private Integer nextEventWait;
        private Workflow workflow;
        private Locale locale;

        public Builder(String number, String brand) {
            this.number = number;
            this.brand = brand;
        }

        public Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public Builder pinExpiry(Integer pinExpiry) {
            this.pinExpiry = pinExpiry;
            return this;
        }

        public Builder nextEventWait(Integer nextEventWait) {
            this.nextEventWait = nextEventWait;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder pinCode(String pinCode) {
            this.pinCode = pinCode;
            return this;
        }

        public VerifyRequest build() {
            return new VerifyRequest(this);
        }
    }
}

