/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.verify2.AbstractNumberWorkflow;
import com.vonage.client.verify2.Channel;
import java.net.URI;

public final class SilentAuthWorkflow
extends AbstractNumberWorkflow {
    private final Boolean sandbox;
    private final URI redirectUrl;

    SilentAuthWorkflow(Builder builder) {
        super(builder);
        this.sandbox = builder.sandbox;
        this.redirectUrl = builder.redirectUrl != null ? URI.create(builder.redirectUrl) : null;
    }

    public SilentAuthWorkflow(String to) {
        this(SilentAuthWorkflow.builder(to));
    }

    public SilentAuthWorkflow(String to, boolean sandbox) {
        this(SilentAuthWorkflow.builder(to).sandbox(sandbox));
    }

    public SilentAuthWorkflow(String to, boolean sandbox, String redirectUrl) {
        this(SilentAuthWorkflow.builder(to).redirectUrl(redirectUrl).sandbox(sandbox));
    }

    @JsonProperty(value="sandbox")
    public Boolean getSandbox() {
        return this.sandbox;
    }

    @JsonProperty(value="redirect_url")
    public URI getRedirectUrl() {
        return this.redirectUrl;
    }

    public static Builder builder(String to) {
        return new Builder(to);
    }

    public static final class Builder
    extends AbstractNumberWorkflow.Builder<SilentAuthWorkflow, Builder> {
        private Boolean sandbox;
        private String redirectUrl;

        private Builder(String to) {
            super(Channel.SILENT_AUTH, to);
        }

        public Builder sandbox(boolean sandbox) {
            this.sandbox = sandbox;
            return this;
        }

        public Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        @Override
        public SilentAuthWorkflow build() {
            return new SilentAuthWorkflow(this);
        }
    }
}

