/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.verify2.Channel;
import java.util.Objects;

public class Workflow
extends JsonableBaseObject {
    protected final Channel channel;
    protected final String to;
    protected final String from;

    protected Workflow(Builder<?, ?> builder) {
        this(builder.channel, builder.to, builder.from);
    }

    protected Workflow(Channel channel, String to) {
        this(channel, to, null);
    }

    protected Workflow(Channel channel, String to, String from) {
        this.channel = Objects.requireNonNull(channel, "Verification channel is required.");
        this.to = this.validateTo(to);
        this.from = this.validateFrom(from);
    }

    protected String validateTo(String to) {
        if (to == null || to.trim().isEmpty()) {
            throw new IllegalArgumentException("Recipient is required.");
        }
        return to;
    }

    protected String validateFrom(String from) {
        if (from != null && from.trim().length() < 3) {
            throw new IllegalArgumentException("Sender must be at least 3 characters long.");
        }
        return from;
    }

    @JsonProperty(value="channel")
    public Channel getChannel() {
        return this.channel;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    protected static abstract class Builder<W extends Workflow, B extends Builder<? extends W, ? extends B>> {
        protected final Channel channel;
        protected String to;
        protected String from;

        protected Builder(Channel channel) {
            this.channel = channel;
        }

        protected B to(String to) {
            this.to = to;
            return (B)this;
        }

        protected B from(String from) {
            this.from = from;
            return (B)this;
        }

        public abstract W build();
    }
}

