/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.video.ArchiveStatus;
import com.vonage.client.video.OutputMode;
import com.vonage.client.video.Resolution;
import com.vonage.client.video.StreamComposition;
import com.vonage.client.video.StreamCompositionLayout;
import com.vonage.client.video.StreamMode;
import java.net.URI;
import java.time.Duration;

public class Archive
extends StreamComposition {
    private Long size;
    @JsonProperty(value="duration")
    private Integer duration;
    private String name;
    private String reason;
    private String multiArchiveTag;
    private URI url;
    private ArchiveStatus status;
    private OutputMode outputMode;
    private Integer quantizationParameter;

    protected Archive() {
    }

    protected Archive(Builder builder) {
        this.sessionId = builder.sessionId;
        if (this.sessionId == null || this.sessionId.isEmpty()) {
            throw new IllegalArgumentException("Session ID is required.");
        }
        this.layout = builder.layout;
        this.outputMode = builder.outputMode;
        if (this.outputMode != OutputMode.COMPOSED && this.layout != null) {
            throw new IllegalStateException("Layout can only be applied to composed archives.");
        }
        this.name = builder.name;
        this.multiArchiveTag = builder.multiArchiveTag;
        this.hasAudio = builder.hasAudio;
        this.hasVideo = builder.hasVideo;
        this.resolution = builder.resolution;
        this.streamMode = builder.streamMode;
        this.maxBitrate = builder.maxBitrate;
        if (this.maxBitrate != null && (this.maxBitrate < 100000 || this.maxBitrate > 6000000)) {
            throw new IllegalArgumentException("Maximum bitrate must be between 100000 and 6000000.");
        }
        this.quantizationParameter = builder.quantizationParameter;
        if (this.quantizationParameter != null) {
            if (this.maxBitrate != null) {
                throw new IllegalStateException("Quantization parameter is mutually exclusive with maxBitrate.");
            }
            if (this.quantizationParameter < 15 || this.quantizationParameter > 40) {
                throw new IllegalArgumentException("Quantization parameter must be between 15 and 40.");
            }
        }
    }

    @JsonProperty(value="duration")
    public Integer getDurationSeconds() {
        return this.duration;
    }

    @JsonIgnore
    public Duration getDuration() {
        return this.duration != null ? Duration.ofSeconds(this.duration.intValue()) : null;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="size")
    public Long getSize() {
        return this.size;
    }

    @JsonProperty(value="status")
    public ArchiveStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="url")
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="outputMode")
    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    @JsonProperty(value="multiArchiveTag")
    public String getMultiArchiveTag() {
        return this.multiArchiveTag;
    }

    @JsonProperty(value="quantizationParameter")
    public Integer getQuantizationParameter() {
        return this.quantizationParameter;
    }

    public static Builder builder(String sessionId) {
        return new Builder(sessionId);
    }

    public static class Builder
    extends StreamComposition.Builder {
        private String name;
        private String multiArchiveTag;
        private OutputMode outputMode;
        private Integer quantizationParameter;

        Builder(String sessionId) {
            this.sessionId = sessionId;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder hasAudio(boolean hasAudio) {
            this.hasAudio = hasAudio;
            return this;
        }

        public Builder hasVideo(boolean hasVideo) {
            this.hasVideo = hasVideo;
            return this;
        }

        public Builder outputMode(OutputMode outputMode) {
            this.outputMode = outputMode;
            return this;
        }

        public Builder streamMode(StreamMode streamMode) {
            this.streamMode = streamMode;
            return this;
        }

        public Builder layout(StreamCompositionLayout layout) {
            this.layout = layout;
            return this;
        }

        public Builder multiArchiveTag(String multiArchiveTag) {
            this.multiArchiveTag = multiArchiveTag;
            return this;
        }

        public Builder maxBitrate(int maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public Builder quantizationParameter(int quantizationParameter) {
            this.quantizationParameter = quantizationParameter;
            return this;
        }

        public Archive build() {
            return new Archive(this);
        }
    }
}

