/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.video.RtmpStatus;
import java.net.URI;
import java.util.Objects;

public class Rtmp
extends JsonableBaseObject {
    private String id;
    private String streamName;
    private URI serverUrl;
    private RtmpStatus status;

    protected Rtmp() {
    }

    protected Rtmp(Builder builder) {
        this.id = builder.id;
        if (this.id != null && this.id.trim().isEmpty()) {
            throw new IllegalArgumentException("RTMP ID cannot be blank.");
        }
        this.streamName = builder.streamName;
        if (this.streamName == null || this.streamName.trim().isEmpty()) {
            throw new IllegalArgumentException("RTMP stream name cannot be blank.");
        }
        this.serverUrl = URI.create(Objects.requireNonNull(builder.serverUrl, "RTMP server URL is required."));
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="streamName")
    public String getStreamName() {
        return this.streamName;
    }

    @JsonProperty(value="serverUrl")
    public URI getServerUrl() {
        return this.serverUrl;
    }

    @JsonProperty(value="status")
    public RtmpStatus getStatus() {
        return this.status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String streamName;
        private String serverUrl;

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Rtmp build() {
            return new Rtmp(this);
        }
    }
}

