/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import java.util.Objects;

public class SignalRequest
extends JsonableBaseObject {
    private final String type;
    private final String data;
    @JsonIgnore
    String sessionId;
    @JsonIgnore
    String connectionId;

    SignalRequest(Builder builder) {
        this.type = Objects.requireNonNull(builder.type, "Type is required.");
        this.data = Objects.requireNonNull(builder.data, "Data is required.");
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="data")
    public String getData() {
        return this.data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String type;
        private String data;

        Builder() {
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public SignalRequest build() {
            return new SignalRequest(this);
        }
    }
}

