/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.auth.ApiKeyHeaderAuthMethod;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.video.Archive;
import com.vonage.client.video.Broadcast;
import com.vonage.client.video.CaptionsRequest;
import com.vonage.client.video.CaptionsResponse;
import com.vonage.client.video.ConnectRequest;
import com.vonage.client.video.ConnectResponse;
import com.vonage.client.video.CreateSessionRequest;
import com.vonage.client.video.CreateSessionResponse;
import com.vonage.client.video.GetStreamResponse;
import com.vonage.client.video.ListArchivesResponse;
import com.vonage.client.video.ListBroadcastsResponse;
import com.vonage.client.video.ListRendersResponse;
import com.vonage.client.video.ListStreamCompositionsRequest;
import com.vonage.client.video.ListStreamsResponse;
import com.vonage.client.video.MuteSessionRequest;
import com.vonage.client.video.PatchComposedStreamsRequest;
import com.vonage.client.video.ProjectDetails;
import com.vonage.client.video.RenderRequest;
import com.vonage.client.video.RenderResponse;
import com.vonage.client.video.SendDtmfRequest;
import com.vonage.client.video.SessionResourceRequestWrapper;
import com.vonage.client.video.SessionStream;
import com.vonage.client.video.SetStreamLayoutRequest;
import com.vonage.client.video.SignalRequest;
import com.vonage.client.video.SipDialRequest;
import com.vonage.client.video.SipDialResponse;
import com.vonage.client.video.StreamCompositionLayout;
import com.vonage.client.video.TokenOptions;
import com.vonage.client.video.VideoResponseException;
import com.vonage.jwt.Jwt;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;

public class VideoClient {
    final Supplier<? extends Jwt.Builder> newJwtSupplier;
    final RestEndpoint<CreateSessionRequest, CreateSessionResponse[]> createSession;
    final RestEndpoint<String, ListStreamsResponse> listStreams;
    final RestEndpoint<SessionResourceRequestWrapper, GetStreamResponse> getStream;
    final RestEndpoint<SetStreamLayoutRequest, Void> setStreamLayout;
    final RestEndpoint<SignalRequest, Void> signal;
    final RestEndpoint<SignalRequest, Void> signalAll;
    final RestEndpoint<SessionResourceRequestWrapper, Void> forceDisconnect;
    final RestEndpoint<SessionResourceRequestWrapper, Void> muteStream;
    final RestEndpoint<MuteSessionRequest, ProjectDetails> muteSession;
    final RestEndpoint<SipDialRequest, SipDialResponse> sipDial;
    final RestEndpoint<SendDtmfRequest, Void> sendDtmfToSession;
    final RestEndpoint<SendDtmfRequest, Void> sendDtmfToConnection;
    final RestEndpoint<ListStreamCompositionsRequest, ListArchivesResponse> listArchives;
    final RestEndpoint<String, Archive> getArchive;
    final RestEndpoint<String, Archive> stopArchive;
    final RestEndpoint<Archive, Archive> createArchive;
    final RestEndpoint<StreamCompositionLayout, Void> updateArchiveLayout;
    final RestEndpoint<StreamCompositionLayout, Void> updateBroadcastLayout;
    final RestEndpoint<PatchComposedStreamsRequest, Void> patchArchiveStream;
    final RestEndpoint<PatchComposedStreamsRequest, Void> patchBroadcastStream;
    final RestEndpoint<String, Void> deleteArchive;
    final RestEndpoint<String, Void> stopCaptions;
    final RestEndpoint<String, Void> stopRender;
    final RestEndpoint<ListStreamCompositionsRequest, ListBroadcastsResponse> listBroadcasts;
    final RestEndpoint<String, Broadcast> getBroadcast;
    final RestEndpoint<String, Broadcast> stopBroadcast;
    final RestEndpoint<Broadcast, Broadcast> createBroadcast;
    final RestEndpoint<CaptionsRequest, CaptionsResponse> startCaptions;
    final RestEndpoint<ConnectRequest, ConnectResponse> connect;
    final RestEndpoint<RenderRequest, RenderResponse> startRender;
    final RestEndpoint<String, RenderResponse> getRender;
    final RestEndpoint<ListStreamCompositionsRequest, ListRendersResponse> listRenders;

    public VideoClient(final HttpWrapper wrapper) {
        Supplier<JWTAuthMethod> jwtAuthGetter = () -> wrapper.getAuthCollection().getAuth(JWTAuthMethod.class);
        final Supplier<String> appIdGetter = () -> ((JWTAuthMethod)jwtAuthGetter.get()).getApplicationId();
        this.newJwtSupplier = () -> ((JWTAuthMethod)jwtAuthGetter.get()).newJwt();
        class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<T, String> pathGetter, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).authMethod(JWTAuthMethod.class, ApiKeyHeaderAuthMethod.class).responseExceptionType(VideoResponseException.class).requestMethod(method).wrapper(var5_5).pathGetter((arg_0, arg_1) -> Endpoint.lambda$new$0(pathGetter, (Supplier)var6_6, arg_0, arg_1)));
            }

            private static /* synthetic */ String lambda$new$0(Function pathGetter, Supplier appIdGetter2, DynamicEndpoint de, Object req) {
                String base = de.getHttpWrapper().getHttpConfig().getVideoBaseUri();
                String end = (String)pathGetter.apply(req);
                String mid = end.startsWith("/") ? "" : "/v2/project/" + (String)appIdGetter2.get() + "/";
                return base + mid + end;
            }
        }
        this.createSession = new Endpoint(req -> "/session/create", HttpMethod.POST, (Object[])new CreateSessionResponse[0][]);
        this.listStreams = new Endpoint(req -> "session/" + req + "/stream", HttpMethod.GET, (Object[])new ListStreamsResponse[0]);
        this.setStreamLayout = new Endpoint(req -> "session/" + req.sessionId + "/stream", HttpMethod.PUT, (Object[])new Void[0]);
        this.getStream = new Endpoint(req -> "session/" + req.sessionId + "/stream/" + req.resourceId, HttpMethod.GET, (Object[])new GetStreamResponse[0]);
        this.signalAll = new Endpoint(req -> "session/" + req.sessionId + "/signal", HttpMethod.POST, (Object[])new Void[0]);
        this.signal = new Endpoint(req -> "session/" + req.sessionId + "/connection/" + req.connectionId + "/signal", HttpMethod.POST, (Object[])new Void[0]);
        this.forceDisconnect = new Endpoint(req -> "session/" + req.sessionId + "/connection/" + req.resourceId, HttpMethod.DELETE, (Object[])new Void[0]);
        this.muteStream = new Endpoint(req -> "session/" + req.sessionId + "/stream/" + req.resourceId + "/mute", HttpMethod.POST, (Object[])new Void[0]);
        this.muteSession = new Endpoint(req -> "session/" + req.sessionId + "/mute", HttpMethod.POST, (Object[])new ProjectDetails[0]);
        this.updateArchiveLayout = new Endpoint(req -> "archive/" + req.id + "/layout", HttpMethod.PUT, (Object[])new Void[0]);
        this.deleteArchive = new Endpoint(req -> "archive/" + req, HttpMethod.DELETE, (Object[])new Void[0]);
        this.patchArchiveStream = new Endpoint(req -> "archive/" + req.id + "/streams", HttpMethod.PATCH, (Object[])new Void[0]);
        this.stopArchive = new Endpoint(req -> "archive/" + req + "/stop", HttpMethod.POST, (Object[])new Archive[0]);
        this.createArchive = new Endpoint(req -> "archive", HttpMethod.POST, (Object[])new Archive[0]);
        this.listArchives = new Endpoint(req -> "archive", HttpMethod.GET, (Object[])new ListArchivesResponse[0]);
        this.getArchive = new Endpoint(req -> "archive/" + req, HttpMethod.GET, (Object[])new Archive[0]);
        this.sendDtmfToConnection = new Endpoint(req -> "session/" + req.sessionId + "/connection/" + req.connectionId + "/play-dtmf", HttpMethod.POST, (Object[])new Void[0]);
        this.sendDtmfToSession = new Endpoint(req -> "session/" + req.sessionId + "/play-dtmf", HttpMethod.POST, (Object[])new Void[0]);
        this.listBroadcasts = new Endpoint(req -> "broadcast", HttpMethod.GET, (Object[])new ListBroadcastsResponse[0]);
        this.createBroadcast = new Endpoint(req -> "broadcast", HttpMethod.POST, (Object[])new Broadcast[0]);
        this.getBroadcast = new Endpoint(req -> "broadcast/" + req, HttpMethod.GET, (Object[])new Broadcast[0]);
        this.stopBroadcast = new Endpoint(req -> "broadcast/" + req + "/stop", HttpMethod.POST, (Object[])new Broadcast[0]);
        this.updateBroadcastLayout = new Endpoint(req -> "broadcast/" + req.id + "/layout", HttpMethod.PUT, (Object[])new Void[0]);
        this.patchBroadcastStream = new Endpoint(req -> "broadcast/" + req.id + "/streams", HttpMethod.PATCH, (Object[])new Void[0]);
        this.sipDial = new Endpoint(req -> "dial", HttpMethod.POST, (Object[])new SipDialResponse[0]);
        this.startCaptions = new Endpoint(req -> "captions", HttpMethod.POST, (Object[])new CaptionsResponse[0]);
        this.stopCaptions = new Endpoint(req -> "captions/" + req + "/stop", HttpMethod.POST, (Object[])new Void[0]);
        this.connect = new Endpoint(req -> "connect", HttpMethod.POST, (Object[])new ConnectResponse[0]);
        this.startRender = new Endpoint(req -> "render", HttpMethod.POST, (Object[])new RenderResponse[0]);
        this.listRenders = new Endpoint(req -> "render", HttpMethod.GET, (Object[])new ListRendersResponse[0]);
        this.getRender = new Endpoint(req -> "render/" + req, HttpMethod.GET, (Object[])new RenderResponse[0]);
        this.stopRender = new Endpoint(req -> "render/" + req, HttpMethod.DELETE, (Object[])new Void[0]);
    }

    private String validateId(String param, String name, boolean uuid) {
        if (param == null || param.isEmpty()) {
            throw new IllegalArgumentException(name + " ID is required.");
        }
        if (uuid) {
            Objects.requireNonNull(UUID.fromString(param));
        }
        return param;
    }

    private String validateSessionId(String sessionId) {
        return this.validateId(sessionId, "Session", false);
    }

    private String validateConnectionId(String connectionId) {
        return this.validateId(connectionId, "Connection", true);
    }

    private String validateStreamId(String streamId) {
        return this.validateId(streamId, "Stream", true);
    }

    private String validateArchiveId(String archiveId) {
        return this.validateId(archiveId, "Archive", true);
    }

    private String validateBroadcastId(String broadcastId) {
        return this.validateId(broadcastId, "Broadcast", true);
    }

    private String validateRenderId(String renderId) {
        return this.validateId(renderId, "Render", true);
    }

    private <T> T validateRequest(T request) {
        if (request == null) {
            throw new IllegalArgumentException("Request properties are required.");
        }
        return request;
    }

    public String generateToken(String sessionId, TokenOptions options) {
        Jwt.Builder jwtBuilder = this.newJwtSupplier.get();
        if (options == null) {
            options = TokenOptions.builder().build();
        }
        options.addClaims(jwtBuilder);
        return jwtBuilder.addClaim("session_id", (Object)this.validateSessionId(sessionId)).addClaim("scope", (Object)"session.connect").issuedAt(ZonedDateTime.now()).build().generate();
    }

    public String generateToken(String sessionId) {
        return this.generateToken(sessionId, null);
    }

    public CreateSessionResponse createSession() {
        return this.createSession(null);
    }

    public CreateSessionResponse createSession(CreateSessionRequest request) {
        CreateSessionResponse[] response = this.createSession.execute(request);
        return response.length == 0 ? new CreateSessionResponse() : response[0];
    }

    public List<GetStreamResponse> listStreams(String sessionId) {
        return this.listStreams.execute(this.validateSessionId(sessionId)).getItems();
    }

    public GetStreamResponse getStream(String sessionId, String streamId) {
        return this.getStream.execute(new SessionResourceRequestWrapper(this.validateSessionId(sessionId), this.validateStreamId(streamId)));
    }

    public void setStreamLayout(String sessionId, List<SessionStream> streams) {
        this.setStreamLayout.execute(new SetStreamLayoutRequest(this.validateSessionId(sessionId), streams));
    }

    public void setStreamLayout(String sessionId, SessionStream ... streams) {
        this.setStreamLayout(sessionId, Arrays.asList(streams));
    }

    public void signalAll(String sessionId, SignalRequest request) {
        this.validateRequest(request);
        request.sessionId = this.validateSessionId(sessionId);
        this.signalAll.execute(request);
    }

    public void signal(String sessionId, String connectionId, SignalRequest request) {
        this.validateRequest(request);
        request.sessionId = this.validateSessionId(sessionId);
        request.connectionId = this.validateConnectionId(connectionId);
        this.signal.execute(request);
    }

    public void forceDisconnect(String sessionId, String connectionId) {
        this.forceDisconnect.execute(new SessionResourceRequestWrapper(this.validateSessionId(sessionId), this.validateConnectionId(connectionId)));
    }

    public void muteStream(String sessionId, String streamId) {
        this.muteStream.execute(new SessionResourceRequestWrapper(this.validateSessionId(sessionId), this.validateStreamId(streamId)));
    }

    public ProjectDetails muteSession(String sessionId, boolean active, Collection<String> excludedStreamIds) {
        return this.muteSession.execute(new MuteSessionRequest(this.validateSessionId(sessionId), active, excludedStreamIds));
    }

    public void muteSession(String sessionId, boolean active, String ... excludedStreamIds) {
        this.muteSession(sessionId, active, excludedStreamIds != null && excludedStreamIds.length > 0 ? Arrays.asList(excludedStreamIds) : null);
    }

    public SipDialResponse sipDial(SipDialRequest request) {
        return this.sipDial.execute(this.validateRequest(request));
    }

    public void sendDtmf(String sessionId, String connectionId, String digits) {
        this.sendDtmfToConnection.execute(new SendDtmfRequest(this.validateSessionId(sessionId), this.validateConnectionId(connectionId), digits));
    }

    public void sendDtmf(String sessionId, String digits) {
        this.sendDtmfToSession.execute(new SendDtmfRequest(this.validateSessionId(sessionId), null, digits));
    }

    public List<Archive> listArchives() {
        return this.listArchives(ListStreamCompositionsRequest.maxResults());
    }

    public List<Archive> listArchives(ListStreamCompositionsRequest request) {
        return this.listArchives.execute(request).getItems();
    }

    public Archive getArchive(String archiveId) {
        return this.getArchive.execute(this.validateArchiveId(archiveId));
    }

    public Archive createArchive(Archive request) {
        return this.createArchive.execute(this.validateRequest(request));
    }

    public void updateArchiveLayout(String archiveId, StreamCompositionLayout layout) {
        this.validateRequest(layout);
        layout.id = this.validateArchiveId(archiveId);
        this.updateArchiveLayout.execute(layout);
    }

    public void addArchiveStream(String archiveId, String streamId) {
        this.addArchiveStream(archiveId, streamId, null, null);
    }

    public void addArchiveStream(String archiveId, String streamId, Boolean audio, Boolean video) {
        this.patchArchiveStream(archiveId, new PatchComposedStreamsRequest(this.validateStreamId(streamId), audio, video));
    }

    public void removeArchiveStream(String archiveId, String streamId) {
        this.patchArchiveStream(archiveId, new PatchComposedStreamsRequest(this.validateStreamId(streamId)));
    }

    private void patchArchiveStream(String archiveId, PatchComposedStreamsRequest request) {
        PatchComposedStreamsRequest pasr = this.validateRequest(request);
        pasr.id = this.validateArchiveId(archiveId);
        this.patchArchiveStream.execute(pasr);
    }

    public Archive stopArchive(String archiveId) {
        return this.stopArchive.execute(this.validateArchiveId(archiveId));
    }

    public void deleteArchive(String archiveId) {
        this.deleteArchive.execute(this.validateArchiveId(archiveId));
    }

    public List<Broadcast> listBroadcasts() {
        return this.listBroadcasts(ListStreamCompositionsRequest.maxResults());
    }

    public List<Broadcast> listBroadcasts(ListStreamCompositionsRequest request) {
        return this.listBroadcasts.execute(request).getItems();
    }

    public Broadcast getBroadcast(String broadcastId) {
        return this.getBroadcast.execute(this.validateBroadcastId(broadcastId));
    }

    public Broadcast createBroadcast(Broadcast request) {
        return this.createBroadcast.execute(this.validateRequest(request));
    }

    public void updateBroadcastLayout(String broadcastId, StreamCompositionLayout layout) {
        this.validateRequest(layout);
        layout.id = this.validateBroadcastId(broadcastId);
        this.updateBroadcastLayout.execute(layout);
    }

    public void addBroadcastStream(String broadcastId, String streamId) {
        this.addBroadcastStream(broadcastId, streamId, null, null);
    }

    public void addBroadcastStream(String broadcastId, String streamId, Boolean audio, Boolean video) {
        this.patchBroadcastStream(broadcastId, new PatchComposedStreamsRequest(this.validateStreamId(streamId), audio, video));
    }

    public void removeBroadcastStream(String broadcastId, String streamId) {
        this.patchBroadcastStream(broadcastId, new PatchComposedStreamsRequest(this.validateStreamId(streamId)));
    }

    private void patchBroadcastStream(String broadcastId, PatchComposedStreamsRequest request) {
        PatchComposedStreamsRequest pasr = this.validateRequest(request);
        pasr.id = this.validateBroadcastId(broadcastId);
        this.patchBroadcastStream.execute(pasr);
    }

    public Broadcast stopBroadcast(String broadcastId) {
        return this.stopBroadcast.execute(this.validateBroadcastId(broadcastId));
    }

    public CaptionsResponse startCaptions(CaptionsRequest request) {
        return this.startCaptions.execute(this.validateRequest(request));
    }

    public void stopCaptions(String captionsId) {
        this.stopCaptions.execute(this.validateId(captionsId, "Captions", true));
    }

    public ConnectResponse connectToWebsocket(ConnectRequest request) {
        return this.connect.execute(this.validateRequest(request));
    }

    public List<RenderResponse> listRenders() {
        return this.listRenders(ListStreamCompositionsRequest.maxResults());
    }

    public List<RenderResponse> listRenders(ListStreamCompositionsRequest request) {
        return this.listRenders.execute(request).getItems();
    }

    public RenderResponse getRender(String renderId) {
        return this.getRender.execute(this.validateRenderId(renderId));
    }

    public RenderResponse startRender(RenderRequest request) {
        return this.startRender.execute(this.validateRequest(request));
    }

    public void stopRender(String renderId) {
        this.stopRender.execute(this.validateRenderId(renderId));
    }
}

