/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.video.ConnectRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Websocket
extends JsonableBaseObject {
    private URI uri;
    private Collection<String> streams;
    private Map<String, String> headers;
    private AudioRate audioRate;

    Websocket() {
    }

    Websocket(ConnectRequest.Builder builder) {
        String uriStr = Objects.requireNonNull(builder.uri, "WebSocket URI is required.");
        if (!uriStr.startsWith("ws://") && !uriStr.startsWith("wss://")) {
            throw new IllegalArgumentException("Invalid URI protocol: must start with ws:// or wss://");
        }
        this.uri = URI.create(builder.uri);
        if (builder.streams != null) {
            this.streams = builder.streams instanceof List ? builder.streams : new ArrayList<String>(builder.streams);
        }
        this.headers = builder.headers;
        this.audioRate = builder.audioRate;
    }

    @JsonProperty(value="uri")
    public URI getUri() {
        return this.uri;
    }

    @JsonProperty(value="streams")
    public Collection<String> getStreams() {
        return this.streams;
    }

    @JsonProperty(value="headers")
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="audioRate")
    public AudioRate getAudioRate() {
        return this.audioRate;
    }

    public static enum AudioRate {
        L16_8K,
        L16_16K;


        @JsonValue
        public int getAudioRate() {
            return this == L16_8K ? 8000 : 16000;
        }

        @JsonCreator
        public static AudioRate fromInt(int value) {
            switch (value) {
                case 8: 
                case 8000: {
                    return L16_8K;
                }
                case 16: 
                case 16000: {
                    return L16_16K;
                }
            }
            throw new IllegalArgumentException("Unsupported sample rate: " + value);
        }
    }
}

