/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.AdvancedMachineDetection;
import com.vonage.client.voice.CallEndpoint;
import com.vonage.client.voice.MachineDetection;
import com.vonage.client.voice.PhoneEndpoint;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.EventMethod;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class Call
extends JsonableBaseObject {
    private CallEndpoint[] to;
    private CallEndpoint from;
    private EventMethod answerMethod;
    private EventMethod eventMethod;
    private Collection<URI> answerUrl;
    private Collection<URI> eventUrl;
    private MachineDetection machineDetection;
    private AdvancedMachineDetection advancedMachineDetection;
    private Integer lengthTimer;
    private Integer ringingTimer;
    private Boolean fromRandomNumber;
    private Collection<? extends Action> ncco;

    Call(Builder builder) {
        this.to = builder.to;
        if (this.to == null || this.to.length == 0 || this.to[0] == null) {
            throw new IllegalStateException("At least one recipient should be specified.");
        }
        this.lengthTimer = builder.lengthTimer;
        if (this.lengthTimer != null && (this.lengthTimer > 86400 || this.lengthTimer < 1)) {
            throw new IllegalArgumentException("Length timer must be between 1 and 86400.");
        }
        this.ringingTimer = builder.ringingTimer;
        if (this.ringingTimer != null && (this.ringingTimer > 120 || this.ringingTimer < 1)) {
            throw new IllegalArgumentException("Ringing timer must be between 1 and 120.");
        }
        this.from = builder.from;
        if (this.from == null) {
            this.fromRandomNumber = true;
        } else {
            this.fromRandomNumber = builder.fromRandomNumber;
            if (this.fromRandomNumber != null && this.fromRandomNumber.booleanValue()) {
                throw new IllegalStateException("From number shouldn't be set if using random.");
            }
        }
        this.answerMethod = builder.answerMethod;
        this.eventMethod = builder.eventMethod;
        this.answerUrl = builder.answerUrl != null ? Collections.singletonList(URI.create(builder.answerUrl)) : null;
        this.eventUrl = builder.eventUrl != null ? Collections.singletonList(URI.create(builder.eventUrl)) : null;
        this.ncco = builder.ncco;
        this.advancedMachineDetection = builder.advancedMachineDetection;
        this.machineDetection = builder.machineDetection;
        if (this.machineDetection != null && this.advancedMachineDetection != null) {
            throw new IllegalStateException("Cannot set both machineDetection and advancedMachineDetection.");
        }
    }

    Call() {
    }

    public Call(String to, String from, String answerUrl) {
        this((CallEndpoint)new PhoneEndpoint(to), (CallEndpoint)new PhoneEndpoint(from), answerUrl);
    }

    public Call(CallEndpoint to, CallEndpoint from, String answerUrl) {
        this(Call.builder().to(to).from(from).answerUrl(answerUrl));
    }

    public Call(String to, String from, Collection<? extends Action> ncco) {
        this((CallEndpoint)new PhoneEndpoint(to), (CallEndpoint)new PhoneEndpoint(from), ncco);
    }

    public Call(CallEndpoint to, CallEndpoint from, Collection<? extends Action> ncco) {
        this(Call.builder().to(to).from(from).ncco(ncco));
    }

    @JsonProperty(value="to")
    public CallEndpoint[] getTo() {
        return this.to;
    }

    @JsonProperty(value="from")
    public CallEndpoint getFrom() {
        return this.from;
    }

    @JsonProperty(value="answer_url")
    public Collection<URI> getAnswerUrl() {
        return this.answerUrl;
    }

    @JsonProperty(value="answer_method")
    public EventMethod getAnswerMethod() {
        if (this.answerUrl == null || this.answerMethod == null) {
            return null;
        }
        return this.answerMethod;
    }

    @JsonProperty(value="event_url")
    public Collection<URI> getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="event_method")
    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    @JsonProperty(value="machine_detection")
    public MachineDetection getMachineDetection() {
        return this.machineDetection;
    }

    @JsonProperty(value="advanced_machine_detection")
    public AdvancedMachineDetection getAdvancedMachineDetection() {
        return this.advancedMachineDetection;
    }

    @JsonProperty(value="length_timer")
    public Integer getLengthTimer() {
        return this.lengthTimer;
    }

    @JsonProperty(value="ringing_timer")
    public Integer getRingingTimer() {
        return this.ringingTimer;
    }

    @JsonProperty(value="random_from_number")
    public Boolean getFromRandomNumber() {
        return this.fromRandomNumber;
    }

    @JsonProperty(value="ncco")
    public Collection<? extends Action> getNcco() {
        return this.ncco;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CallEndpoint[] to;
        private CallEndpoint from;
        private EventMethod answerMethod = EventMethod.GET;
        private EventMethod eventMethod;
        private String answerUrl;
        private String eventUrl;
        private MachineDetection machineDetection;
        private AdvancedMachineDetection advancedMachineDetection;
        private Integer lengthTimer;
        private Integer ringingTimer;
        private Boolean fromRandomNumber;
        private Collection<Action> ncco;

        Builder() {
        }

        public Builder to(CallEndpoint ... endpoints) {
            this.to = endpoints;
            return this;
        }

        public Builder from(String caller) {
            return this.from(new PhoneEndpoint(caller));
        }

        Builder from(CallEndpoint from) {
            this.from = from;
            return this;
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public Builder answerMethod(EventMethod answerMethod) {
            this.answerMethod = answerMethod;
            return this;
        }

        public Builder eventUrl(String eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder answerUrl(String answerUrl) {
            this.answerUrl = answerUrl;
            return this;
        }

        public Builder machineDetection(MachineDetection machineDetection) {
            this.machineDetection = machineDetection;
            return this;
        }

        public Builder advancedMachineDetection(AdvancedMachineDetection advancedMachineDetection) {
            this.advancedMachineDetection = advancedMachineDetection;
            return this;
        }

        public Builder lengthTimer(int lengthTimer) {
            this.lengthTimer = lengthTimer;
            return this;
        }

        public Builder ringingTimer(int ringingTimer) {
            this.ringingTimer = ringingTimer;
            return this;
        }

        public Builder fromRandomNumber(boolean fromRandomNumber) {
            this.fromRandomNumber = fromRandomNumber;
            return this;
        }

        public Builder ncco(Action ... actions) {
            return this.ncco(Arrays.asList(actions));
        }

        public Builder ncco(Collection<? extends Action> nccos) {
            this.ncco = new ArrayList<Action>(nccos);
            return this;
        }

        public Call build() {
            return new Call(this);
        }
    }
}

