/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.DtmfSettings;
import com.vonage.client.voice.ncco.EventMethod;
import com.vonage.client.voice.ncco.InputMode;
import com.vonage.client.voice.ncco.SpeechSettings;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class InputAction
extends JsonableBaseObject
implements Action {
    private Collection<String> type;
    private DtmfSettings dtmf;
    private Collection<URI> eventUrl;
    private SpeechSettings speech;
    private EventMethod eventMethod;
    private InputMode mode;

    InputAction() {
    }

    private InputAction(Builder builder) {
        this.eventUrl = builder.eventUrl != null ? Collections.singletonList(URI.create(builder.eventUrl)) : null;
        this.eventMethod = builder.eventMethod;
        this.speech = builder.speech;
        this.mode = builder.mode;
        this.type = builder.type;
        if (this.type.isEmpty()) {
            throw new IllegalStateException("At least one input type must be specified.");
        }
        this.dtmf = builder.dtmf;
        if (this.dtmf != null && this.mode == InputMode.ASYNCHRONOUS) {
            throw new IllegalStateException("DTMF settings cannot be used with asynchronous mode.");
        }
    }

    @Override
    public String getAction() {
        return "input";
    }

    @JsonProperty(value="type")
    public Collection<String> getType() {
        return this.type;
    }

    @JsonProperty(value="dtmf")
    public DtmfSettings getDtmf() {
        return this.dtmf;
    }

    @JsonProperty(value="eventUrl")
    public Collection<URI> getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="eventMethod")
    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    @JsonProperty(value="speech")
    public SpeechSettings getSpeech() {
        return this.speech;
    }

    @JsonProperty(value="mode")
    public InputMode getMode() {
        return this.mode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Collection<String> type = new LinkedHashSet<String>(2, 1.0f);
        private DtmfSettings dtmf;
        private String eventUrl;
        private EventMethod eventMethod;
        private SpeechSettings speech;
        private InputMode mode;

        private Builder() {
        }

        public Builder dtmf() {
            this.dtmf(null);
            this.type.add("dtmf");
            return this;
        }

        public Builder dtmf(DtmfSettings dtmf) {
            this.dtmf = dtmf;
            if (this.dtmf != null) {
                this.type.add("dtmf");
            } else {
                this.type.remove("dtmf");
            }
            return this;
        }

        public Builder speech(SpeechSettings speech) {
            this.speech = speech;
            if (this.speech != null) {
                this.type.add("speech");
            } else {
                this.type.remove("speech");
            }
            return this;
        }

        public Builder eventUrl(String eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public Builder mode(InputMode mode) {
            this.mode = mode;
            return this;
        }

        public InputAction build() {
            return new InputAction(this);
        }
    }
}

