/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.EventMethod;
import com.vonage.client.voice.ncco.RecordingFormat;
import com.vonage.client.voice.ncco.SplitRecording;
import com.vonage.client.voice.ncco.TranscriptionSettings;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;

public final class RecordAction
extends JsonableBaseObject
implements Action {
    private RecordingFormat format;
    private Integer endOnSilence;
    private Integer timeOut;
    private Integer channels;
    private Character endOnKey;
    private Boolean beepStart;
    private Collection<URI> eventUrl;
    private EventMethod eventMethod;
    private SplitRecording split;
    private TranscriptionSettings transcription;

    RecordAction() {
    }

    private RecordAction(Builder builder) {
        this.format = builder.format;
        this.endOnSilence = builder.endOnSilence;
        this.endOnKey = builder.endOnKey;
        this.timeOut = builder.timeOut;
        this.beepStart = builder.beepStart;
        this.eventUrl = builder.eventUrl != null ? Collections.singletonList(URI.create(builder.eventUrl)) : null;
        this.eventMethod = builder.eventMethod;
        this.split = builder.channels != null && builder.channels > 1 ? SplitRecording.CONVERSATION : null;
        this.channels = builder.channels;
        this.transcription = builder.transcription;
    }

    @Override
    public String getAction() {
        return "record";
    }

    @JsonProperty(value="format")
    public RecordingFormat getFormat() {
        return this.format;
    }

    @JsonProperty(value="endOnSilence")
    public Integer getEndOnSilence() {
        return this.endOnSilence;
    }

    @JsonProperty(value="endOnKey")
    public Character getEndOnKey() {
        return this.endOnKey;
    }

    @JsonProperty(value="timeOut")
    public Integer getTimeOut() {
        return this.timeOut;
    }

    @JsonProperty(value="beepStart")
    public Boolean getBeepStart() {
        return this.beepStart;
    }

    @JsonProperty(value="eventUrl")
    public Collection<URI> getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="eventMethod")
    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    @JsonProperty(value="split")
    public SplitRecording getSplit() {
        return this.split;
    }

    @JsonProperty(value="channels")
    public Integer getChannels() {
        return this.channels;
    }

    @JsonProperty(value="transcription")
    public TranscriptionSettings getTranscription() {
        return this.transcription;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private RecordingFormat format;
        private Character endOnKey;
        private Integer timeOut;
        private Integer channels;
        private Integer endOnSilence;
        private Boolean beepStart;
        private String eventUrl;
        private EventMethod eventMethod;
        private TranscriptionSettings transcription;

        Builder() {
        }

        public Builder format(RecordingFormat format) {
            this.format = format;
            return this;
        }

        public Builder endOnSilence(int endOnSilence) {
            this.endOnSilence = endOnSilence;
            return this;
        }

        public Builder endOnKey(char endOnKey) {
            this.endOnKey = Character.valueOf(endOnKey);
            return this;
        }

        public Builder timeOut(int timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public Builder beepStart(boolean beepStart) {
            this.beepStart = beepStart;
            return this;
        }

        public Builder eventUrl(String eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public Builder channels(int channels) {
            this.channels = channels;
            return this;
        }

        public Builder transcription(TranscriptionSettings transcription) {
            this.transcription = transcription;
            return this;
        }

        public RecordAction build() {
            return new RecordAction(this);
        }
    }
}

