/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.EndpointType;
import com.vonage.client.voice.SipHeader;
import com.vonage.client.voice.ncco.ConnectEndpoint;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public class SipEndpoint
extends JsonableBaseObject
implements ConnectEndpoint {
    private final URI uri;
    private final String domain;
    private final String user;
    private final Map<String, ?> headers;
    private final Map<SipHeader, String> standardHeaders;

    private SipEndpoint(Builder builder) {
        this.uri = builder.uri;
        this.domain = builder.domain;
        this.user = builder.user;
        if (this.uri == null && this.domain == null) {
            throw new IllegalStateException("Domain or SIP URI must be specified.");
        }
        if (this.uri != null && (this.domain != null || this.user != null)) {
            throw new IllegalStateException("Either SIP URI or domain/user must be specified, not both.");
        }
        this.headers = builder.headers;
        this.standardHeaders = builder.standardHeaders;
    }

    @Override
    public EndpointType getType() {
        return EndpointType.SIP;
    }

    @JsonProperty(value="uri")
    public URI getUri() {
        return this.uri;
    }

    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="user")
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="headers")
    public Map<String, ?> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="standardHeaders")
    public Map<SipHeader, String> getStandardHeaders() {
        return this.standardHeaders;
    }

    public static Builder builder(String uri) {
        return new Builder().uri(uri);
    }

    public static Builder builder(URI uri) {
        return new Builder().uri(uri);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private URI uri;
        private String domain;
        private String user;
        private Map<String, ?> headers;
        private Map<SipHeader, String> standardHeaders;

        private Builder() {
        }

        private Builder addStandardHeader(SipHeader key, String value) {
            if (this.standardHeaders == null) {
                this.standardHeaders = new LinkedHashMap<SipHeader, String>(2);
            }
            this.standardHeaders.put(key, value);
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder uri(String uri) {
            return this.uri(URI.create(uri));
        }

        public Builder headers(Map<String, ?> headers) {
            this.headers = headers;
            return this;
        }

        public Builder userToUserHeader(String value) {
            return this.addStandardHeader(SipHeader.USER_TO_USER, value);
        }

        public SipEndpoint build() {
            return new SipEndpoint(this);
        }
    }
}

