/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.ncco.Language;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class SpeechSettings
extends JsonableBaseObject {
    private Collection<String> uuid;
    private Collection<String> context;
    private Double endOnSilence;
    private Integer startTimeout;
    private Integer maxDuration;
    private Integer sensitivity;
    private Language language;
    private Boolean saveAudio;

    SpeechSettings() {
    }

    private SpeechSettings(Builder builder) {
        if (builder.uuid != null) {
            this.uuid = Collections.singletonList(builder.uuid);
        }
        if ((this.endOnSilence = builder.endOnSilence) != null && (this.endOnSilence < 0.4 || this.endOnSilence > 10.0)) {
            throw new IllegalArgumentException("endOnSilence must be between 0.4 and 10.");
        }
        this.startTimeout = builder.startTimeout;
        if (this.startTimeout != null && (this.startTimeout < 1 || this.startTimeout > 60)) {
            throw new IllegalArgumentException("startTimeout must be between 1 and 60.");
        }
        this.maxDuration = builder.maxDuration;
        if (this.maxDuration != null && (this.maxDuration < 1 || this.maxDuration > 60)) {
            throw new IllegalArgumentException("maxDuration must be between 1 and 60.");
        }
        this.sensitivity = builder.sensitivity;
        if (this.sensitivity != null && (this.sensitivity < 10 || this.sensitivity > 100)) {
            throw new IllegalArgumentException("sensitivity must be between 10 and 100.");
        }
        this.context = builder.context;
        this.language = builder.language;
        this.saveAudio = builder.saveAudio;
    }

    @JsonProperty(value="uuid")
    public Collection<String> getUuid() {
        return this.uuid;
    }

    @JsonProperty(value="language")
    public Language getLanguage() {
        return this.language;
    }

    @JsonProperty(value="context")
    public Collection<String> getContext() {
        return this.context;
    }

    @JsonProperty(value="endOnSilence")
    public Double getEndOnSilence() {
        return this.endOnSilence;
    }

    @JsonProperty(value="startTimeout")
    public Integer getStartTimeout() {
        return this.startTimeout;
    }

    @JsonProperty(value="maxDuration")
    public Integer getMaxDuration() {
        return this.maxDuration;
    }

    @JsonProperty(value="sensitivity")
    public Integer getSensitivity() {
        return this.sensitivity;
    }

    @JsonProperty(value="saveAudio")
    public Boolean getSaveAudio() {
        return this.saveAudio;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String uuid;
        private Collection<String> context;
        private Integer startTimeout;
        private Integer maxDuration;
        private Integer sensitivity;
        private Double endOnSilence;
        private Language language;
        private Boolean saveAudio;

        private Builder() {
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder context(Collection<String> context) {
            this.context = context;
            return this;
        }

        public Builder context(String ... context) {
            return this.context(Arrays.asList(context));
        }

        public Builder endOnSilence(double endOnSilence) {
            this.endOnSilence = endOnSilence;
            return this;
        }

        public Builder startTimeout(int startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        public Builder maxDuration(int maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder sensitivity(int sensitivity) {
            this.sensitivity = sensitivity;
            return this;
        }

        public Builder language(Language language) {
            this.language = language;
            return this;
        }

        public Builder saveAudio(boolean saveAudio) {
            this.saveAudio = saveAudio;
            return this;
        }

        public SpeechSettings build() {
            return new SpeechSettings(this);
        }
    }
}

