/*
 * Copyright 2012 - 2014 Weald Technology Trading Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the specific language governing permissions and limitations under the License.
 */

package com.wealdtech.jetty;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;

import com.wealdtech.jetty.config.JettyConnectorConfiguration;

/**
 * Definition of a factory to create Jetty connectors.
 *
 * @see ServerConnector
 */
public interface JettyConnectorFactory
{
  ServerConnector build(final Server server, final ThreadPool threadPool, final String name, final JettyConnectorConfiguration config, final SslContextFactory sslContextFactory);
}
