/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jersey.exceptions;

import com.google.common.base.Optional;
import com.wealdtech.WealdError;
import javax.ws.rs.core.Response;

public class HttpException
extends WealdError {
    private static final long serialVersionUID = -2193964229153866237L;
    private final Response.Status status;
    private final Optional<Integer> retryAfter;

    public HttpException(Response.Status status, String message, String userMessage) {
        super(message, userMessage, null, null);
        this.status = status;
        this.retryAfter = Optional.absent();
    }

    public HttpException(Response.Status status, Throwable t) {
        super(null, null, null, t);
        this.status = status;
        this.retryAfter = Optional.absent();
    }

    public HttpException(Response.Status status, String message, String userMessage, Throwable t) {
        super(message, userMessage, null, t);
        this.status = status;
        this.retryAfter = Optional.absent();
    }

    public HttpException(Response.Status status, String message, String userMessage, Integer retryAfter, Throwable t) {
        super(message, userMessage, null, t);
        this.status = status;
        this.retryAfter = Optional.fromNullable((Object)retryAfter);
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public Optional<Integer> getRetryAfter() {
        return this.retryAfter;
    }

    public String toString() {
        String s = ((Object)((Object)this)).getClass().getName();
        String message = this.getLocalizedMessage();
        return message != null ? message : s;
    }

    public String getThrowingClassName() {
        WealdError we = null;
        for (Throwable t = this.getCause(); t != null; t = t.getCause()) {
            if (!(t instanceof WealdError)) continue;
            we = (WealdError)t;
        }
        String result = null;
        StackTraceElement[] stacktrace = we.getStackTrace();
        if (stacktrace.length > 0) {
            result = stacktrace[0].getClassName();
        }
        return result;
    }

    public String getThrowingMethodName() {
        WealdError we = null;
        for (Throwable t = this.getCause(); t != null; t = t.getCause()) {
            if (!(t instanceof WealdError)) continue;
            we = (WealdError)t;
        }
        String result = null;
        StackTraceElement[] stacktrace = we.getStackTrace();
        if (stacktrace.length > 0) {
            result = stacktrace[0].getMethodName();
        }
        return result;
    }

    public String getFullyQualifiedMessage() {
        String methodName;
        StringBuilder sb = new StringBuilder(128);
        String className = this.getThrowingClassName();
        if (className != null) {
            sb.append(className);
            sb.append(':');
        }
        if ((methodName = this.getThrowingMethodName()) != null) {
            sb.append(methodName);
            sb.append(':');
        }
        sb.append(this.toString());
        return sb.toString();
    }
}

