/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jersey.filters;

import com.wealdtech.ServerError;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyPrefetchFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BodyPrefetchFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        BufferedRequestWrapper bufferedRequest = new BufferedRequestWrapper(httpServletRequest);
        chain.doFilter((ServletRequest)bufferedRequest, (ServletResponse)httpServletResponse);
    }

    private static final class BufferedServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream inputStream;

        public BufferedServletInputStream(ByteArrayInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public int available() {
            return this.inputStream.available();
        }

        public int read() {
            return this.inputStream.read();
        }

        public int read(byte[] buf, int off, int len) {
            return this.inputStream.read(buf, off, len);
        }

        public boolean isFinished() {
            throw new ServerError("Not implemented");
        }

        public boolean isReady() {
            throw new ServerError("Not implemented");
        }

        public void setReadListener(ReadListener readListener) {
            throw new ServerError("Not implemented");
        }
    }

    private static final class BufferedRequestWrapper
    extends HttpServletRequestWrapper {
        private byte[] body = null;

        public BufferedRequestWrapper(HttpServletRequest req) throws IOException {
            super(req);
            int bytesRead;
            ServletInputStream is = req.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((bytesRead = is.read(buf)) > 0) {
                baos.write(buf, 0, bytesRead);
            }
            this.body = baos.toByteArray();
            if (this.body.length > 0) {
                LOGGER.debug("Body of request is \"{}\"", (Object)new String(this.body, "UTF-8"));
            }
        }

        public ServletInputStream getInputStream() {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
            return new BufferedServletInputStream(bais);
        }
    }
}

