/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jersey.filters;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.wealdtech.jersey.config.CORSConfiguration;

public class CORSFilter
implements ContainerResponseFilter {
    private static final String ORIGINHEADER = "Origin";
    private static final String ACAOHEADER = "Access-Control-Allow-Origin";
    private static final String ACRHHEADER = "Access-Control-Request-Headers";
    private static final String ACAHHEADER = "Access-Control-Allow-Headers";
    private static final String ACAMHEADER = "Access-Control-Allow-Methods";
    private static final String ACACHEADER = "Access-Control-Allow-Credentials";
    private final transient CORSConfiguration configuration;

    @Inject
    public CORSFilter(CORSConfiguration configuration) {
        this.configuration = configuration;
    }

    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        if (this.configuration.reflectRequest()) {
            response.getHttpHeaders().add((Object)ACAOHEADER, (Object)request.getHeaderValue(ORIGINHEADER));
        } else {
            response.getHttpHeaders().add((Object)ACAOHEADER, (Object)this.configuration.getOrigin());
        }
        String requestHeaders = request.getHeaderValue(ACRHHEADER);
        response.getHttpHeaders().add((Object)ACAHHEADER, (Object)requestHeaders);
        response.getHttpHeaders().add((Object)ACAMHEADER, (Object)this.configuration.getAllowedMethods());
        response.getHttpHeaders().add((Object)ACACHEADER, (Object)this.configuration.allowCredentials());
        return response;
    }
}

