/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jersey.filters;

import com.google.common.base.Splitter;
import com.google.common.net.InetAddresses;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.wealdtech.utils.RequestHint;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHintFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestHintFilter.class);
    @Context
    HttpServletRequest req;

    public ContainerRequest filter(ContainerRequest request) {
        RequestHint.Builder builder = RequestHint.builder();
        builder.userAgent(request.getHeaderValue("User-Agent"));
        String geoPosition = request.getHeaderValue("Geo-Position");
        if (geoPosition != null) {
            Iterator geoItems = geoPosition.indexOf(32) != -1 ? Splitter.on((String)";").split((CharSequence)Splitter.on((String)" ").split((CharSequence)geoPosition).iterator().next()).iterator() : Splitter.on((String)";").split((CharSequence)geoPosition).iterator();
            if (geoItems.hasNext()) {
                String lat = (String)geoItems.next();
                builder.latitude(Float.valueOf(lat).floatValue());
            }
            if (geoItems.hasNext()) {
                String lng = (String)geoItems.next();
                builder.longitude(Float.valueOf(lng).floatValue());
            }
            if (geoItems.hasNext()) {
                String alt = (String)geoItems.next();
                builder.altitude(Float.valueOf(alt).floatValue());
            }
        }
        try {
            builder.address(InetAddresses.forString((String)this.req.getRemoteAddr()));
        }
        catch (IllegalArgumentException ignored) {
            LOG.debug("Remote IP address {} could not be parsed", (Object)this.req.getRemoteAddr());
        }
        this.req.setAttribute("com.wealdtech.requesthint", (Object)builder.build());
        return request;
    }
}

