/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jersey.filters;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RequestLoggingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestLoggingFilter.class);
    private static final String REQUEST_ID_HEADER = "Request-ID";
    private static final String REQUEST_ID = "REQUEST_ID";
    private static final String REQUEST_START_TIME = "RSTARTTIME";

    public ContainerRequest filter(ContainerRequest request) {
        String requestId = Long.toHexString(Double.doubleToLongBits(Math.random()));
        MDC.put((String)REQUEST_ID, (String)requestId);
        MDC.put((String)REQUEST_START_TIME, (String)String.valueOf(System.currentTimeMillis()));
        if (LOG.isInfoEnabled()) {
            LOG.info("Started: {} {} ({})", new Object[]{request.getMethod(), request.getRequestUri(), requestId});
        }
        return request;
    }

    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        try {
            Long startTime = Long.parseLong(MDC.get((String)REQUEST_START_TIME));
            String rid = MDC.get((String)REQUEST_ID);
            long duration = System.currentTimeMillis() - startTime;
            response.getHttpHeaders().add((Object)REQUEST_ID_HEADER, (Object)rid);
            LOG.info("Finished: {} {} [{}] ({} ms)", new Object[]{request.getMethod(), request.getPath(), response.getStatus(), String.valueOf(duration)});
        }
        catch (Exception e) {
            LOG.warn("Finished {} {} [{}]", new Object[]{request.getMethod(), request.getPath(), response.getStatus()});
        }
        return response;
    }
}

