/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jersey.guice;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.container.filter.GZIPContentEncodingFilter;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.wealdtech.jersey.filters.CORSFilter;
import com.wealdtech.jersey.filters.RequestHintFilter;
import com.wealdtech.jersey.filters.RequestLoggingFilter;
import com.wealdtech.jersey.filters.ServerHeaderFilter;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class JerseyServletModule
extends ServletModule {
    private String packages;

    public JerseyServletModule(String ... packages) {
        this.setPackages(packages);
    }

    protected void configureServlets() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("com.sun.jersey.config.property.packages", this.packages);
        params.put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE.toString());
        String requestFilters = this.joinClassNames(RequestLoggingFilter.class, RequestHintFilter.class, GZIPContentEncodingFilter.class);
        String responseFilters = this.joinClassNames(RequestLoggingFilter.class, ServerHeaderFilter.class, CORSFilter.class, GZIPContentEncodingFilter.class);
        params.put("com.sun.jersey.spi.container.ContainerRequestFilters", requestFilters);
        params.put("com.sun.jersey.spi.container.ContainerResponseFilters", responseFilters);
        this.serve("/*", new String[0]).with(GuiceContainer.class, params);
    }

    private void setPackages(String ... additionalPackages) {
        Object[] packagesList = (String[])ObjectArrays.concat((Object)"com.wealdtech.jersey", (Object[])additionalPackages);
        packagesList = (String[])ObjectArrays.concat((Object)"com.codahale.metrics", (Object[])packagesList);
        this.packages = Joiner.on((char)',').skipNulls().join(packagesList);
    }

    private String joinClassNames(Class<?> ... clazz) {
        Function classToName = new Function<Class<?>, String>(){

            public String apply(Class<?> klazz) {
                return klazz.getName();
            }
        };
        List names = Lists.transform((List)Lists.newArrayList((Object[])clazz), (Function)classToName);
        return Joiner.on((char)',').skipNulls().join((Iterable)names);
    }

    static {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.install();
        Logger.getLogger("global").setLevel(Level.FINEST);
    }
}

