/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jersey.providers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wealdtech.WealdError;
import com.wealdtech.errors.ErrorInfo;
import com.wealdtech.jackson.ObjectMapperFactory;
import com.wealdtech.jersey.exceptions.HttpException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class HttpExceptionMapper
implements ExceptionMapper<HttpException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpExceptionMapper.class);
    private static final transient ObjectMapper MAPPER = ObjectMapperFactory.getDefaultMapper();

    public Response toResponse(HttpException exception) {
        Response.ResponseBuilder builder = Response.status((Response.Status)exception.getStatus()).entity((Object)this.statusToJSON(exception)).type("application/json");
        if (exception.getRetryAfter().isPresent()) {
            builder.header("Retry-After", exception.getRetryAfter().get());
        }
        return builder.build();
    }

    private String statusToJSON(HttpException exception) {
        HttpException err = exception;
        for (Throwable t = exception.getCause(); t != null; t = t.getCause()) {
            if (!(t instanceof WealdError)) continue;
            err = (WealdError)t;
        }
        ErrorInfo errorInfo = new ErrorInfo(null, err.getUserMessage(), err.getMessage(), err.getUrl());
        try {
            return MAPPER.writeValueAsString((Object)errorInfo);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to generate JSON for status \"{}\"", (Object)errorInfo);
            return "{\"message\":\"An error occurred\"}";
        }
    }
}

