/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jersey.providers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Objects;
import com.wealdtech.errors.ErrorInfo;
import com.wealdtech.jackson.ObjectMapperFactory;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JsonMappingExceptionManager
implements ExceptionMapper<JsonMappingException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonMappingExceptionManager.class);
    private static final transient ObjectMapper MAPPER = ObjectMapperFactory.getDefaultMapper();

    public Response toResponse(JsonMappingException exception) {
        LOGGER.info("JSON mapping exception", (Throwable)exception);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.defaultJSON((Throwable)Objects.firstNonNull((Object)exception.getCause(), (Object)exception))).type("application/json");
        return builder.build();
    }

    private String defaultJSON(Throwable exception) {
        ErrorInfo errorInfo = new ErrorInfo(null, exception.getMessage(), exception.getMessage(), (String)null);
        try {
            return MAPPER.writeValueAsString((Object)errorInfo);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to generate JSON for status \"{}\"", (Object)errorInfo);
            return "{\"message\":\"An error occurred\"}";
        }
    }
}

