/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jetty;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jetty9.InstrumentedConnectionFactory;
import com.wealdtech.jetty.JettyConnectorFactory;
import com.wealdtech.jetty.config.JettyConnectorConfiguration;
import com.wealdtech.utils.WealdMetrics;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyHttpConnectorFactory
implements JettyConnectorFactory {
    @Override
    public ServerConnector build(Server server, ThreadPool threadPool, String name, JettyConnectorConfiguration configuration, SslContextFactory sslContextFactory) {
        HttpConfiguration httpConfig = this.buildHttpConfiguration(configuration);
        HttpConnectionFactory httpConnectionFactory = this.buildHttpConnectionFactory(httpConfig, configuration);
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        ByteBufferPool bufferPool = this.buildBufferPool(configuration);
        String timerName = MetricRegistry.name(HttpConnectionFactory.class, (String[])new String[]{configuration.getBindHost(), Integer.toString(configuration.getPort()), "connections"});
        InstrumentedConnectionFactory instrumentedConnectionFactory = new InstrumentedConnectionFactory((ConnectionFactory)httpConnectionFactory, WealdMetrics.getMetricRegistry().timer(timerName));
        return this.buildConnector(server, threadPool, (Scheduler)scheduler, bufferPool, name, configuration, new ConnectionFactory[]{instrumentedConnectionFactory});
    }

    protected HttpConfiguration buildHttpConfiguration(JettyConnectorConfiguration configuration) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setHeaderCacheSize(configuration.getHeaderCacheSize());
        httpConfig.setOutputBufferSize(configuration.getOutputBufferSize());
        httpConfig.setRequestHeaderSize(configuration.getRequestHeaderSize());
        httpConfig.setResponseHeaderSize(configuration.getResponseHeaderSize());
        httpConfig.setSendDateHeader(configuration.getSendDateHeader());
        httpConfig.setSendServerVersion(configuration.getSendServerVersion());
        if (configuration.useForwardedHeaders()) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        httpConfig.setSecureScheme(HttpScheme.HTTPS.asString());
        return httpConfig;
    }

    protected HttpConnectionFactory buildHttpConnectionFactory(HttpConfiguration httpConfig, JettyConnectorConfiguration configuration) {
        HttpConnectionFactory factory = new HttpConnectionFactory(httpConfig);
        factory.setInputBufferSize(configuration.getInputBufferSize());
        return factory;
    }

    protected ServerConnector buildConnector(Server server, ThreadPool threadPool, Scheduler scheduler, ByteBufferPool bufferPool, String name, JettyConnectorConfiguration configuration, ConnectionFactory ... connectionFactories) {
        ServerConnector connector = new ServerConnector(server, (Executor)threadPool, scheduler, bufferPool, configuration.getAcceptorThreads(), configuration.getSelectorThreads(), connectionFactories);
        this.setConnectorProperties(connector, name, configuration);
        return connector;
    }

    protected void setConnectorProperties(ServerConnector connector, String name, JettyConnectorConfiguration configuration) {
        connector.setName(name);
        connector.setPort(configuration.getPort());
        connector.setHost(configuration.getBindHost());
        connector.setIdleTimeout(configuration.getIdleTimeout());
        connector.setAcceptQueueSize(configuration.getAcceptQueueSize());
        connector.setReuseAddress(configuration.getReuseAddress());
        connector.setSoLingerTime(configuration.getSoLingerTime());
    }

    protected ByteBufferPool buildBufferPool(JettyConnectorConfiguration configuration) {
        return new ArrayByteBufferPool(configuration.getMinBufferPoolSize(), configuration.getBufferPoolIncrement(), configuration.getMaxBufferPoolSize());
    }
}

