/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jetty;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jetty9.InstrumentedConnectionFactory;
import com.wealdtech.jetty.JettyHttpConnectorFactory;
import com.wealdtech.jetty.config.JettyConnectorConfiguration;
import com.wealdtech.utils.WealdMetrics;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyHttpsConnectorFactory
extends JettyHttpConnectorFactory {
    @Override
    public ServerConnector build(Server server, ThreadPool threadPool, String name, JettyConnectorConfiguration configuration, SslContextFactory sslContextFactory) {
        HttpConfiguration httpConfig = this.buildHttpConfiguration(configuration);
        HttpConnectionFactory httpConnectionFactory = this.buildHttpConnectionFactory(httpConfig, configuration);
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        ByteBufferPool bufferPool = this.buildBufferPool(configuration);
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.toString());
        String timerName = MetricRegistry.name(HttpConnectionFactory.class, (String[])new String[]{configuration.getBindHost(), Integer.toString(configuration.getPort()), "connections"});
        InstrumentedConnectionFactory instrumentedConnectionFactory = new InstrumentedConnectionFactory((ConnectionFactory)httpConnectionFactory, WealdMetrics.getMetricRegistry().timer(timerName));
        return this.buildConnector(server, threadPool, (Scheduler)scheduler, bufferPool, name, configuration, new ConnectionFactory[]{sslConnectionFactory, instrumentedConnectionFactory});
    }

    @Override
    protected ServerConnector buildConnector(Server server, ThreadPool threadPool, Scheduler scheduler, ByteBufferPool bufferPool, String name, JettyConnectorConfiguration configuration, ConnectionFactory ... connectionFactories) {
        ServerConnector connector = super.buildConnector(server, threadPool, scheduler, bufferPool, name, configuration, connectionFactories);
        super.setConnectorProperties(connector, name, configuration);
        return connector;
    }

    @Override
    protected HttpConfiguration buildHttpConfiguration(JettyConnectorConfiguration configuration) {
        HttpConfiguration httpConfig = super.buildHttpConfiguration(configuration);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return httpConfig;
    }
}

