/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jetty;

import com.codahale.metrics.servlets.AdminServlet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.wealdtech.DataError;
import com.wealdtech.jersey.filters.BodyPrefetchFilter;
import com.wealdtech.jersey.filters.ThreadNameFilter;
import com.wealdtech.jetty.JettyConnectorFactory;
import com.wealdtech.jetty.JettySslContextFactoryFactory;
import com.wealdtech.jetty.JettyThreadPoolFactory;
import com.wealdtech.jetty.config.JettyConnectorConfiguration;
import com.wealdtech.jetty.config.JettyInstanceConfiguration;
import com.wealdtech.jetty.config.JettyServerConfiguration;
import com.wealdtech.jetty.config.MetricsServletContextListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyServer.class);
    private transient Server server;
    private final transient Injector injector;

    @Inject
    public JettyServer(Injector injector, JettyServerConfiguration configuration) {
        this.injector = injector;
        this.server = new Server();
        ArrayList connectors = Lists.newArrayList();
        for (JettyInstanceConfiguration instanceConfiguration : configuration.getInstanceConfigurations()) {
            connectors.addAll(this.configureInstance(this.server, instanceConfiguration));
        }
        this.server.setConnectors(connectors.toArray(new Connector[0]));
        this.server.setHandler((Handler)this.createHandlers(configuration));
    }

    public void start() throws Exception {
        this.server.start();
    }

    public boolean isRunning() {
        return this.server != null && this.server.isRunning();
    }

    public void join() throws Exception {
        if (this.server != null) {
            this.server.join();
        }
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void waitForShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.join();
        }
    }

    private List<Connector> configureInstance(Server server, JettyInstanceConfiguration configuration) {
        SslContextFactory sslContextFactory = JettySslContextFactoryFactory.build(configuration.getSslConfiguration());
        ThreadPool threadPool = JettyThreadPoolFactory.build(configuration.getName(), configuration.getThreadPoolConfiguration());
        ArrayList connectors = Lists.newArrayList();
        for (JettyConnectorConfiguration connectorConfiguration : configuration.getConnectorConfigurations()) {
            JettyConnectorFactory factory;
            LOGGER.debug("Creating connector {}:{} for instance \"{}\"", new Object[]{connectorConfiguration.getBindHost(), connectorConfiguration.getPort(), configuration.getName()});
            try {
                Constructor<? extends JettyConnectorFactory> ctor = connectorConfiguration.getType().getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                factory = ctor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new DataError.Bad("Failed to set up connector type \"" + connectorConfiguration.getType() + "\"");
            }
            connectors.add(factory.build(server, threadPool, configuration.getName(), connectorConfiguration, sslContextFactory));
        }
        return connectors;
    }

    private HandlerCollection createHandlers(JettyServerConfiguration configuration) {
        HandlerCollection handlers = new HandlerCollection();
        ServletContextHandler admin = new ServletContextHandler();
        admin.addEventListener((EventListener)((Object)new MetricsServletContextListener()));
        admin.setContextPath(configuration.getMetricsEndpoint());
        admin.addServlet(AdminServlet.class, "/*");
        handlers.addHandler((Handler)admin);
        ServletContextHandler root = new ServletContextHandler();
        root.addEventListener((EventListener)new GuiceServletContextListener(){

            protected Injector getInjector() {
                return JettyServer.this.injector;
            }
        });
        if (configuration.getDetailedThreadName()) {
            root.addFilter(ThreadNameFilter.class, "/*", null);
        }
        if (configuration.getBodyPrefetch()) {
            root.addFilter(BodyPrefetchFilter.class, "/*", null);
        }
        root.addFilter(GuiceFilter.class, "/*", null);
        root.addServlet(DefaultServlet.class, "/");
        handlers.addHandler((Handler)root);
        return handlers;
    }

    public void registerHandler(String path, Class<? extends Servlet> klazz) {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath(path);
        context.addServlet(klazz, "/*");
        this.server.setHandler((Handler)context);
    }
}

