/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jetty.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.wealdtech.configuration.Configuration;
import com.wealdtech.jetty.JettyConnectorFactory;
import com.wealdtech.jetty.JettyHttpConnectorFactory;
import com.wealdtech.jetty.JettyHttpsConnectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JettyConnectorConfiguration
implements Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyConnectorConfiguration.class);
    private String bindHost = "localhost";
    private int port = 8080;
    private Class<? extends JettyConnectorFactory> type = JettyHttpConnectorFactory.class;
    private int acceptQueueSize = -1;
    private long idleTimeout = 50000L;
    private boolean reuseAddress = false;
    private int soLingerTime = 60;
    private int inputBufferSize = 32768;
    private int outputBufferSize = 32768;
    private int requestHeaderSize = 8192;
    private int responseHeaderSize = 8192;
    private int headerCacheSize = 512;
    private boolean sendServerVersion = true;
    private boolean sendDateHeader = true;
    private boolean useForwardedHeaders = true;
    private int acceptorThreads = 8;
    private int selectorThreads = 8;
    private int minBufferPoolSize = 64;
    private int bufferPoolIncrement = 2048;
    private int maxBufferPoolSize = 65536;

    public JettyConnectorConfiguration() {
    }

    @JsonCreator
    private JettyConnectorConfiguration(@JsonProperty(value="bindhost") String bindHost, @JsonProperty(value="port") Integer port, @JsonProperty(value="type") String type, @JsonProperty(value="acceptqueuesize") Integer acceptQueueSize, @JsonProperty(value="idletimeout") Long idleTimeout, @JsonProperty(value="reuseaddress") Boolean reuseAddress, @JsonProperty(value="solingertime") Integer soLingerTime, @JsonProperty(value="headercachesize") Integer headerCacheSize, @JsonProperty(value="inputbuffersize") Integer inputBufferSize, @JsonProperty(value="outputbuffersize") Integer outputBufferSize, @JsonProperty(value="requestheadersize") Integer requestHeaderSize, @JsonProperty(value="responseheadersize") Integer responseHeaderSize, @JsonProperty(value="sendserverversion") Boolean sendServerVersion, @JsonProperty(value="senddateheader") Boolean sendDateHeader, @JsonProperty(value="useforwardedheaders") Boolean userForwardedHeaders, @JsonProperty(value="acceptorthreads") Integer acceptorThreads, @JsonProperty(value="selectorthreads") Integer selectorThreads, @JsonProperty(value="minbufferpoolsize") Integer minBufferPoolSize, @JsonProperty(value="bufferpoolincrement") Integer bufferPoolIncremenet, @JsonProperty(value="maxbufferpoolsize") Integer maxBufferPoolSize) {
        this.bindHost = (String)Objects.firstNonNull((Object)bindHost, (Object)this.bindHost);
        this.port = (Integer)Objects.firstNonNull((Object)port, (Object)this.port);
        this.type = (Class)Objects.firstNonNull(this.classFromType(type), this.type);
        this.acceptQueueSize = (Integer)Objects.firstNonNull((Object)acceptQueueSize, (Object)this.acceptQueueSize);
        this.idleTimeout = (Long)Objects.firstNonNull((Object)idleTimeout, (Object)this.idleTimeout);
        this.reuseAddress = (Boolean)Objects.firstNonNull((Object)reuseAddress, (Object)this.reuseAddress);
        this.soLingerTime = (Integer)Objects.firstNonNull((Object)soLingerTime, (Object)this.soLingerTime);
        this.requestHeaderSize = (Integer)Objects.firstNonNull((Object)requestHeaderSize, (Object)this.requestHeaderSize);
        this.responseHeaderSize = (Integer)Objects.firstNonNull((Object)responseHeaderSize, (Object)this.responseHeaderSize);
        this.headerCacheSize = (Integer)Objects.firstNonNull((Object)inputBufferSize, (Object)this.headerCacheSize);
        this.inputBufferSize = (Integer)Objects.firstNonNull((Object)inputBufferSize, (Object)this.inputBufferSize);
        this.outputBufferSize = (Integer)Objects.firstNonNull((Object)outputBufferSize, (Object)this.outputBufferSize);
        this.sendServerVersion = (Boolean)Objects.firstNonNull((Object)sendServerVersion, (Object)this.sendServerVersion);
        this.sendDateHeader = (Boolean)Objects.firstNonNull((Object)sendDateHeader, (Object)this.sendDateHeader);
        this.useForwardedHeaders = (Boolean)Objects.firstNonNull((Object)this.useForwardedHeaders, (Object)this.useForwardedHeaders);
        this.acceptorThreads = (Integer)Objects.firstNonNull((Object)acceptorThreads, (Object)this.acceptorThreads);
        this.selectorThreads = (Integer)Objects.firstNonNull((Object)selectorThreads, (Object)this.selectorThreads);
        this.minBufferPoolSize = (Integer)Objects.firstNonNull((Object)minBufferPoolSize, (Object)this.minBufferPoolSize);
        this.bufferPoolIncrement = (Integer)Objects.firstNonNull((Object)this.bufferPoolIncrement, (Object)this.bufferPoolIncrement);
        this.maxBufferPoolSize = (Integer)Objects.firstNonNull((Object)maxBufferPoolSize, (Object)this.maxBufferPoolSize);
    }

    public String getBindHost() {
        return this.bindHost;
    }

    public int getPort() {
        return this.port;
    }

    public Class<? extends JettyConnectorFactory> getType() {
        return this.type;
    }

    public int getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public int getSoLingerTime() {
        return this.soLingerTime;
    }

    public int getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public int getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public boolean getSendServerVersion() {
        return this.sendServerVersion;
    }

    public boolean getSendDateHeader() {
        return this.sendDateHeader;
    }

    public boolean useForwardedHeaders() {
        return this.useForwardedHeaders;
    }

    public int getAcceptorThreads() {
        return this.acceptorThreads;
    }

    public int getSelectorThreads() {
        return this.selectorThreads;
    }

    public int getMinBufferPoolSize() {
        return this.minBufferPoolSize;
    }

    public int getBufferPoolIncrement() {
        return this.bufferPoolIncrement;
    }

    public int getMaxBufferPoolSize() {
        return this.maxBufferPoolSize;
    }

    private Class<? extends JettyConnectorFactory> classFromType(String type) {
        Class<JettyHttpConnectorFactory> klazz = null;
        if (type != null) {
            switch (type.toLowerCase()) {
                case "http": {
                    klazz = JettyHttpConnectorFactory.class;
                    break;
                }
                case "https": {
                    klazz = JettyHttpsConnectorFactory.class;
                    break;
                }
                default: {
                    LOGGER.error("Unknown connector type \"{}\"", (Object)type);
                }
            }
        }
        return klazz;
    }
}

