/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jetty.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.wealdtech.configuration.Configuration;
import com.wealdtech.jetty.config.JettyInstanceConfiguration;
import com.wealdtech.jetty.config.JettyResponseConfiguration;
import java.util.Collection;
import java.util.List;

public final class JettyServerConfiguration
implements Configuration {
    private boolean bodyPrefetch = true;
    private boolean detailedThreadName = true;
    private JettyResponseConfiguration responseConfiguration = new JettyResponseConfiguration();
    private ImmutableList<JettyInstanceConfiguration> instanceConfigurations = ImmutableList.of((Object)new JettyInstanceConfiguration());
    private String metricsEndpoint = "/admin";

    @Inject
    public JettyServerConfiguration() {
    }

    @JsonCreator
    private JettyServerConfiguration(@JsonProperty(value="bodyprefetchenabled") Boolean bodyPrefetch, @JsonProperty(value="detailedthreadnameenabled") Boolean detailedThreadName, @JsonProperty(value="response") JettyResponseConfiguration responseConfiguration, @JsonProperty(value="instances") List<JettyInstanceConfiguration> instanceConfigurations, @JsonProperty(value="metricsendpoint") String metricsEndpoint) {
        this.bodyPrefetch = (Boolean)Objects.firstNonNull((Object)bodyPrefetch, (Object)this.bodyPrefetch);
        this.detailedThreadName = (Boolean)Objects.firstNonNull((Object)detailedThreadName, (Object)this.detailedThreadName);
        this.responseConfiguration = (JettyResponseConfiguration)Objects.firstNonNull((Object)responseConfiguration, (Object)this.responseConfiguration);
        this.instanceConfigurations = ImmutableList.copyOf((Collection)((Collection)Objects.firstNonNull(instanceConfigurations, this.instanceConfigurations)));
        this.metricsEndpoint = (String)Objects.firstNonNull((Object)metricsEndpoint, (Object)this.metricsEndpoint);
    }

    public boolean getBodyPrefetch() {
        return this.bodyPrefetch;
    }

    public boolean getDetailedThreadName() {
        return this.detailedThreadName;
    }

    public JettyResponseConfiguration getResponseConfiguration() {
        return this.responseConfiguration;
    }

    public ImmutableList<JettyInstanceConfiguration> getInstanceConfigurations() {
        return this.instanceConfigurations;
    }

    public String getMetricsEndpoint() {
        return this.metricsEndpoint;
    }
}

