/*
 * Decompiled with CFR 0.152.
 */
package com.wealdtech.jetty.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.wealdtech.configuration.Configuration;
import com.wealdtech.utils.ResourceLoader;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JettySslConfiguration
implements Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettySslConfiguration.class);
    private String keyStorePath = "/etc/keystore";
    private String keyStorePasswd = "password";
    private String keyManagerPasswd = "password";
    private boolean renegotiationAllowed = true;
    private boolean sessionCachingEnabled = true;
    private int sessionCacheSize = 1024;
    private int sessionTimeout = 120;

    public JettySslConfiguration() {
    }

    @JsonCreator
    private JettySslConfiguration(@JsonProperty(value="keystorepath") String keyStorePath, @JsonProperty(value="keystorepassword") String keyStorePasswd, @JsonProperty(value="keymanagerpassword") String keyManagerPasswd, @JsonProperty(value="renegotiationallowed") Boolean renegotiationAllowed, @JsonProperty(value="sessioncachingenabled") Boolean sessionCachingEnabled, @JsonProperty(value="sessioncachesize") Integer sessionCacheSize, @JsonProperty(value="sessiontimeout") Integer sessionTimeout) {
        this.keyStorePath = this.resolvePath((String)Objects.firstNonNull((Object)keyStorePath, (Object)this.keyStorePath));
        this.keyStorePasswd = (String)Objects.firstNonNull((Object)keyStorePasswd, (Object)this.keyStorePasswd);
        this.keyManagerPasswd = (String)Objects.firstNonNull((Object)keyManagerPasswd, (Object)this.keyManagerPasswd);
        this.renegotiationAllowed = (Boolean)Objects.firstNonNull((Object)renegotiationAllowed, (Object)this.renegotiationAllowed);
        this.sessionCachingEnabled = (Boolean)Objects.firstNonNull((Object)sessionCachingEnabled, (Object)this.sessionCachingEnabled);
        this.sessionCacheSize = (Integer)Objects.firstNonNull((Object)sessionCacheSize, (Object)this.sessionCacheSize);
        this.sessionTimeout = (Integer)Objects.firstNonNull((Object)sessionTimeout, (Object)this.sessionTimeout);
    }

    private String resolvePath(String input) {
        URL resourceUrl;
        String result = input;
        if (!input.startsWith("/") && (resourceUrl = ResourceLoader.getResource((String)input)) != null) {
            result = resourceUrl.getPath();
        }
        LOGGER.debug("Resolved path from \"{}\" to \"{}\"", (Object)input, (Object)result);
        return result;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePasswd;
    }

    public String getKeyManagerPassword() {
        return this.keyManagerPasswd;
    }

    public boolean isRenegotiationAllowed() {
        return this.renegotiationAllowed;
    }

    public boolean isSessionCachingEnabled() {
        return this.sessionCachingEnabled;
    }

    public int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }
}

