/**
 * Copyright © 2006-2016 Web Cohesion (info@webcohesion.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.webcohesion.enunciate.modules.jackson.model.types;

/**
 * The marker json type for a map.
 *
 * @author Ryan Heaton
 */
public class JsonArrayType implements JsonType {

  private final JsonType componentType;

  public JsonArrayType(JsonType componentType) {
    this.componentType = componentType;
  }

  /**
   * @return true
   */
  public boolean isObject() {
    return false;
  }

  @Override
  public boolean isArray() {
    return true;
  }

  @Override
  public boolean isString() {
    return false;
  }

  @Override
  public boolean isNumber() {
    return false;
  }

  @Override
  public boolean isWholeNumber() {
    return false;
  }

  @Override
  public boolean isBoolean() {
    return false;
  }

  public JsonType getComponentType() {
    return componentType;
  }
}
